/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.cellery.security.cell.sts.server.core.model.CellStsRequest;
import io.cellery.security.cell.sts.server.core.model.config.CellStsConfiguration;
import io.cellery.security.cell.sts.server.core.service.CelleryCellSTSException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CellStsUtils {
    private static final String STS_CONFIG_PATH_ENV_VARIABLE = "CONF_PATH";
    private static final String UNSECURED_PATHS_ENV_VARIABLE = "UNSECURED_CONTEXTS_CONF_PATH";
    private static final String UNSECURED_PATHS_CONFIG_PATH = "/etc/config/unsecured-paths.json";
    private static final String CONFIG_FILE_PATH = "/etc/config/sts.json";

    public static String getMyCellName() throws CelleryCellSTSException {
        String cellName = CellStsUtils.resolveSystemVariable("CELL_INSTANCE_NAME");
        if (StringUtils.isBlank(cellName)) {
            throw new CelleryCellSTSException("Environment variable 'CELL_INSTANCE_NAME' is empty.");
        }
        return cellName;
    }

    public static String getCellImageName() {
        return CellStsUtils.resolveSystemVariable("CELL_IMAGE_NAME");
    }

    public static String getCellVersion() {
        return CellStsUtils.resolveSystemVariable("CELL_IMAGE_VERSION");
    }

    public static boolean isRequestToMicroGateway(CellStsRequest cellStsRequest) throws CelleryCellSTSException {
        String workload = cellStsRequest.getDestination().getWorkload();
        boolean inferFromDestinationAddress = StringUtils.isNotEmpty(workload) && workload.startsWith(CellStsUtils.getMyCellName() + "--gateway-service");
        return inferFromDestinationAddress || cellStsRequest.isGatewayIncomingRequest();
    }

    public static boolean isWorkloadExternalToCellery(String destinationWorkloadName) {
        return !StringUtils.contains(destinationWorkloadName, "--");
    }

    public static String getPrettyPrintJson(Map<String, String> attributes) {
        JSONObject configJson = new JSONObject();
        attributes.forEach((key, value) -> configJson.put(key, value));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(configJson);
    }

    public static String getIssuerName(String cellName) {
        return cellName + "--sts-service";
    }

    public static String getGatewayIssuer(String cellName) {
        return cellName + "--gateway";
    }

    public static String getConfigFilePath() {
        String configPath = CellStsUtils.resolveSystemVariable(STS_CONFIG_PATH_ENV_VARIABLE);
        return StringUtils.isNotBlank(configPath) ? configPath : CONFIG_FILE_PATH;
    }

    public static String getUnsecuredPathsConfigPath() {
        String configPath = CellStsUtils.resolveSystemVariable(UNSECURED_PATHS_ENV_VARIABLE);
        return StringUtils.isNotBlank(configPath) ? configPath : UNSECURED_PATHS_CONFIG_PATH;
    }

    public static void buildCellStsConfiguration() throws CelleryCellSTSException {
        try {
            String configFilePath = CellStsUtils.getConfigFilePath();
            String content = new String(Files.readAllBytes(Paths.get(configFilePath, new String[0])), StandardCharsets.UTF_8);
            JSONObject config = (JSONObject)new JSONParser().parse(content);
            CellStsConfiguration.getInstance().setCellName(CellStsUtils.getMyCellName()).setStsEndpoint((String)config.get("endpoint")).setUsername((String)config.get("username")).setPassword((String)config.get("password")).setGlobalJWKEndpoint((String)config.get("globalJWKS")).setSignatureValidationEnabled(Boolean.parseBoolean(String.valueOf(config.get("enableSignatureValidation")))).setAudienceValidationEnabled(Boolean.parseBoolean(String.valueOf(config.get("enableAudienceValidation")))).setIssuerValidationEnabled(Boolean.parseBoolean(String.valueOf(config.get("enableIssuerValidation")))).setSTSOPAQueryPrefix((String)config.get("OPAQueryPrefix")).setAuthorizationEnabled(Boolean.parseBoolean(String.valueOf(config.get("enableAuthorization"))));
        }
        catch (IOException | ParseException e) {
            throw new CelleryCellSTSException("Error while setting up STS configurations", e);
        }
    }

    public static void readUnsecuredContexts() throws CelleryCellSTSException {
        String configFilePath = CellStsUtils.getUnsecuredPathsConfigPath();
        String content = null;
        try {
            content = new String(Files.readAllBytes(Paths.get(configFilePath, new String[0])), StandardCharsets.UTF_8);
            JSONArray config = (JSONArray)new JSONParser().parse(content);
            List<String> unsecuredContexts = config.subList(0, config.size());
            CellStsConfiguration.getInstance().setUnsecuredAPIS(unsecuredContexts);
        }
        catch (IOException | ParseException e) {
            throw new CelleryCellSTSException("Error while reading unsecured contexts from config file", e);
        }
    }

    public static boolean isRunningInDebugMode() {
        return StringUtils.isNotEmpty(CellStsUtils.resolveSystemVariable("debug"));
    }

    public static String resolveSystemVariable(String variableName) {
        String systemVariable = System.getProperty(variableName);
        if (StringUtils.isEmpty(systemVariable)) {
            systemVariable = System.getenv(variableName);
        }
        return systemVariable;
    }

    public static boolean isCompositeSTS() {
        try {
            return "composite".equalsIgnoreCase(CellStsUtils.getMyCellName());
        }
        catch (CelleryCellSTSException e) {
            return false;
        }
    }

    public static String extractJwtFromAuthzHeader(String authzHeader) {
        if (StringUtils.isBlank(authzHeader)) {
            return null;
        }
        String[] split = authzHeader.split("\\s+");
        return split.length > 1 ? split[1] : null;
    }

    public static String getAuthorizationHeaderValue(Map<String, String> requestHeaders) {
        String celleryAuthorizationHeader = requestHeaders.get("cellery-authorization");
        if (StringUtils.isBlank(celleryAuthorizationHeader)) {
            celleryAuthorizationHeader = requestHeaders.get("authorization");
        }
        return celleryAuthorizationHeader;
    }
}

