/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core;

import io.cellery.security.cell.sts.server.core.CellStsUtils;
import io.cellery.security.cell.sts.server.core.ConfigUpdater;
import io.cellery.security.cell.sts.server.core.context.store.UserContextStoreImpl;
import io.cellery.security.cell.sts.server.core.service.CelleryCellInboundInterceptorService;
import io.cellery.security.cell.sts.server.core.service.CelleryCellOutboundInterceptorService;
import io.cellery.security.cell.sts.server.core.service.CelleryCellSTSException;
import io.cellery.security.cell.sts.server.core.service.CelleryCellStsService;
import io.cellery.security.cell.sts.server.core.service.CelleryGWInboundInterceptorService;
import io.cellery.security.cell.sts.server.core.service.CelleryGWSTSService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelleryCellSTSServer {
    private static final String CELL_NAME_ENV_VARIABLE = "CELL_NAME";
    private static final Logger log = LoggerFactory.getLogger(CelleryCellSTSServer.class);
    private final int inboundListeningPort;
    private final Server inboundListener;
    private final int outboundListeningPort;
    private final Server outboundListener;
    private final Server gatewayListner;
    private final int gatewayListeningPort;

    private CelleryCellSTSServer(int inboundListeningPort, int outboundListeningPort, int gatewayListeningPort) throws CelleryCellSTSException {
        CellStsUtils.buildCellStsConfiguration();
        CellStsUtils.readUnsecuredContexts();
        UserContextStoreImpl contextStore = new UserContextStoreImpl();
        UserContextStoreImpl localContextStore = new UserContextStoreImpl();
        CelleryCellStsService cellStsService = new CelleryCellStsService(contextStore, localContextStore);
        CelleryGWSTSService celleryGWSTSService = new CelleryGWSTSService(contextStore, localContextStore);
        this.inboundListeningPort = inboundListeningPort;
        this.inboundListener = ((ServerBuilder)ServerBuilder.forPort(inboundListeningPort).addService(new CelleryCellInboundInterceptorService(cellStsService))).build();
        this.outboundListeningPort = outboundListeningPort;
        this.outboundListener = ((ServerBuilder)ServerBuilder.forPort(outboundListeningPort).addService(new CelleryCellOutboundInterceptorService(cellStsService))).build();
        this.gatewayListeningPort = gatewayListeningPort;
        this.gatewayListner = ((ServerBuilder)ServerBuilder.forPort(gatewayListeningPort).addService(new CelleryGWInboundInterceptorService(celleryGWSTSService))).build();
    }

    private void start() throws IOException {
        this.inboundListener.start();
        this.outboundListener.start();
        this.gatewayListner.start();
        log.info("Cellery STS gRPC Server started, listening for inbound traffic on " + this.inboundListeningPort);
        log.info("Cellery STS gRPC Server started, listening for outbound traffic on " + this.outboundListeningPort);
        log.info("Cellery STS gRPC Server started, listening for gateway inbound traffic on " + this.gatewayListeningPort);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.error("Shutting down Cellery Cell STS since JVM is shutting down.");
            this.stop();
            log.error("Cellery Cell STS shut down.");
        }));
    }

    private void stop() {
        if (this.inboundListener != null) {
            this.inboundListener.shutdown();
        }
        if (this.outboundListener != null) {
            this.outboundListener.shutdown();
        }
        if (this.gatewayListner != null) {
            this.gatewayListner.shutdown();
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.inboundListener != null) {
            this.inboundListener.awaitTermination();
        }
        if (this.outboundListener != null) {
            this.outboundListener.awaitTermination();
        }
        if (this.gatewayListner != null) {
            this.gatewayListner.awaitTermination();
        }
    }

    public static void main(String[] args) {
        int inboundListeningPort = CelleryCellSTSServer.getPortFromEnvVariable("inboundPort", 8080);
        int outboundListeningPort = CelleryCellSTSServer.getPortFromEnvVariable("outboundPort", 8081);
        int gatewayInboundPort = CelleryCellSTSServer.getPortFromEnvVariable("gatewayInboundPort", 8082);
        try {
            CelleryCellSTSServer server = new CelleryCellSTSServer(inboundListeningPort, outboundListeningPort, gatewayInboundPort);
            server.start();
            CelleryCellSTSServer.watchConfigChanges();
            server.blockUntilShutdown();
        }
        catch (CelleryCellSTSException | IOException | InterruptedException e) {
            log.error("Error while starting up the Cell STS.", e);
            System.exit(1);
        }
    }

    private static int getPortFromEnvVariable(String name, int defaultPort) {
        if (StringUtils.isNotEmpty(System.getenv(name))) {
            defaultPort = Integer.parseInt(System.getenv(name));
        }
        log.info("Port for {} : {}", (Object)name, (Object)defaultPort);
        return defaultPort;
    }

    private static void watchConfigChanges() {
        Thread fileWatcher = new Thread(new ConfigUpdater());
        fileWatcher.start();
    }
}

