/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core;

import io.cellery.security.cell.sts.server.core.CellStsUtils;
import io.cellery.security.cell.sts.server.core.service.CelleryCellSTSException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUpdater
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ConfigUpdater.class);

    @Override
    public void run() {
        log.info("Running configuration updater..");
        String configFilePath = CellStsUtils.getConfigFilePath();
        Path directoryPath = Paths.get(configFilePath.substring(0, configFilePath.lastIndexOf("/")), new String[0]);
        try {
            block2: while (true) {
                WatchService watcher = directoryPath.getFileSystem().newWatchService();
                directoryPath.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                log.debug("Waiting for config file change");
                WatchKey watckKey = watcher.take();
                List<WatchEvent<?>> events = watckKey.pollEvents();
                log.debug("Received events: ....");
                Iterator<WatchEvent<?>> iterator = events.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    WatchEvent<?> event = iterator.next();
                    if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                        log.info("Updating file on {} event", (Object)StandardWatchEventKinds.ENTRY_CREATE);
                        CellStsUtils.buildCellStsConfiguration();
                        CellStsUtils.readUnsecuredContexts();
                    }
                    if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                    log.info("Updating file on {} event", (Object)StandardWatchEventKinds.ENTRY_MODIFY);
                    CellStsUtils.buildCellStsConfiguration();
                    CellStsUtils.readUnsecuredContexts();
                }
                break;
            }
        }
        catch (CelleryCellSTSException | IOException | InterruptedException e) {
            log.error("Error while updating configurations on file change ", e);
            return;
        }
    }
}

