/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.cellery.security.cell.sts.server.core.service.CelleryCellSTSException;
import io.cellery.security.cell.sts.server.jwks.KeyResolverException;
import io.cellery.security.cell.sts.server.utils.CertificateUtils;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class STSJWTBuilder {
    private static final String MICRO_GATEWAY_DEFAULT_AUDIENCE_VALUE = "http://org.cellery.apimgt/gateway";
    private static final String SCOPE_CLAIM = "scope";
    private static final String KEY_TYPE_CLAIM = "keytype";
    private static final String PRODUCTION_KEY_TYPE = "PRODUCTION";
    private JWSHeader.Builder headerBuilder = new JWSHeader.Builder(JWSAlgorithm.RS256);
    private JWTClaimsSet.Builder claimSetBuilder = new JWTClaimsSet.Builder();
    private long expiryInSeconds = 1200L;
    private List<String> audience = new ArrayList<String>();
    private String issuer = "https://sts.cellry.io";

    public STSJWTBuilder subject(String subject) {
        this.claimSetBuilder.subject(subject);
        return this;
    }

    public STSJWTBuilder issuer(String issuer) {
        if (issuer != null) {
            this.issuer = issuer;
        }
        return this;
    }

    public STSJWTBuilder claim(String name, Object value) {
        this.claimSetBuilder.claim(name, value);
        return this;
    }

    public STSJWTBuilder claims(Map<String, Object> customClaims) {
        customClaims.forEach((x, y) -> this.claimSetBuilder.claim((String)x, y));
        return this;
    }

    public STSJWTBuilder scopes(List<String> scopes) {
        return this.claim(SCOPE_CLAIM, scopes);
    }

    public STSJWTBuilder expiryInSeconds(long expiryInSeconds) {
        this.expiryInSeconds = expiryInSeconds;
        return this;
    }

    public STSJWTBuilder audience(List<String> audience) {
        this.audience = audience;
        return this;
    }

    public STSJWTBuilder audience(String audience) {
        this.audience.add(audience);
        return this;
    }

    public String build() throws CelleryCellSTSException {
        JWSHeader jwsHeader = null;
        try {
            jwsHeader = this.buildJWSHeader();
        }
        catch (KeyResolverException | NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new CelleryCellSTSException("Error while building JWS header", e);
        }
        this.addMandatoryClaims(this.claimSetBuilder);
        JWTClaimsSet claimsSet = this.claimSetBuilder.build();
        SignedJWT signedJWT = new SignedJWT(jwsHeader, claimsSet);
        try {
            RSASSASigner signer = new RSASSASigner(CertificateUtils.getKeyResolver().getPrivateKey());
            signedJWT.sign(signer);
        }
        catch (JOSEException | KeyResolverException e) {
            throw new CelleryCellSTSException("Error while signing JWT", e);
        }
        return signedJWT.serialize();
    }

    private JWSHeader buildJWSHeader() throws KeyResolverException, CertificateEncodingException, NoSuchAlgorithmException {
        String certThumbPrint = null;
        certThumbPrint = CertificateUtils.getThumbPrint(CertificateUtils.getKeyResolver().getCertificate());
        this.headerBuilder.keyID(certThumbPrint);
        this.headerBuilder.x509CertThumbprint(new Base64URL(certThumbPrint));
        return this.headerBuilder.build();
    }

    private void addMandatoryClaims(JWTClaimsSet.Builder claimsSet) {
        Date issuedAt = new Date(System.currentTimeMillis());
        Date expiryTime = new Date(issuedAt.getTime() + this.expiryInSeconds * 1000L);
        List<String> audience = this.getAudience(this.audience);
        claimsSet.jwtID(UUID.randomUUID().toString()).issuer(this.getIssuer()).issueTime(issuedAt).expirationTime(expiryTime).audience(audience).claim(KEY_TYPE_CLAIM, PRODUCTION_KEY_TYPE);
    }

    private String getIssuer() {
        return this.issuer;
    }

    private List<String> getAudience(List<String> audience) {
        if (audience == null || audience.isEmpty()) {
            return Collections.singletonList(MICRO_GATEWAY_DEFAULT_AUDIENCE_VALUE);
        }
        return audience.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }
}

