/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.cellery.security.cell.sts.server.core.CellStsUtils;
import io.cellery.security.cell.sts.server.core.STSJWTBuilder;
import io.cellery.security.cell.sts.server.core.service.CelleryCellSTSException;
import java.text.ParseException;
import java.util.HashMap;

public class STSTokenGenerator {
    public static String generateToken(String incomingJWT, String audience, String issuer, String destination) throws CelleryCellSTSException {
        STSJWTBuilder stsjwtBuilder = new STSJWTBuilder();
        JWTClaimsSet jwtClaims = STSTokenGenerator.getJWTClaims(incomingJWT);
        HashMap<String, Object> originalClaims = new HashMap<String, Object>(jwtClaims.getClaims());
        STSTokenGenerator.replaceCellInformation(originalClaims, destination);
        stsjwtBuilder.subject(jwtClaims.getSubject());
        stsjwtBuilder.expiryInSeconds(1200L);
        stsjwtBuilder.audience(audience);
        stsjwtBuilder.claims(originalClaims);
        stsjwtBuilder.issuer(issuer);
        return stsjwtBuilder.build();
    }

    public static String generateToken(String audience, String issuer, String destination) throws CelleryCellSTSException {
        STSJWTBuilder stsjwtBuilder = new STSJWTBuilder();
        stsjwtBuilder.expiryInSeconds(1200L);
        stsjwtBuilder.audience(audience);
        stsjwtBuilder.issuer(issuer);
        stsjwtBuilder.claims(STSTokenGenerator.replaceCellInformation(new HashMap(), destination));
        return stsjwtBuilder.build();
    }

    public static JWTClaimsSet getJWTClaims(String jwt) throws CelleryCellSTSException {
        try {
            return SignedJWT.parse(jwt).getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new CelleryCellSTSException("Error while parsing the Signed JWT in authorization header.", e);
        }
    }

    private static HashMap replaceCellInformation(HashMap claims, String destination) throws CelleryCellSTSException {
        if (claims == null) {
            claims = new HashMap<String, String>();
        }
        claims.remove("cellImageName");
        claims.remove("cellInstanceName");
        claims.remove("cellVersion");
        claims.remove("destination");
        claims.put("cellImageName", CellStsUtils.getCellImageName());
        claims.put("cellInstanceName", CellStsUtils.getMyCellName());
        claims.put("cellVersion", CellStsUtils.getCellVersion());
        claims.put("destination", destination);
        return claims;
    }
}

