/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.context.store;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.cellery.security.cell.sts.server.core.CellStsUtils;
import io.cellery.security.cell.sts.server.core.context.store.UserContextStore;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserContextStoreImpl
implements UserContextStore {
    private static final String USER_CONTEXT_EXPIRY_IN_SECONDS = "USER_CONTEXT_EXPIRY_SECONDS";
    private static final long DEFAULT_EXPIRY_IN_SECONDS = 300L;
    private static final Logger log = LoggerFactory.getLogger(UserContextStoreImpl.class);
    private Map<String, String> userContextMap;

    public UserContextStoreImpl() {
        log.info("User Context expiry set to {} seconds.", (Object)this.getUserContextExpiry());
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(this.getUserContextExpiry(), TimeUnit.SECONDS).removalListener(removalNotification -> log.debug("Stored user context was removed: " + removalNotification)).build();
        this.userContextMap = cache.asMap();
    }

    private long getUserContextExpiry() {
        long expiryTimeInSecs = 300L;
        String expiryConfigValue = CellStsUtils.resolveSystemVariable(USER_CONTEXT_EXPIRY_IN_SECONDS);
        if (StringUtils.isNotBlank(expiryConfigValue)) {
            try {
                expiryTimeInSecs = Long.parseLong(expiryConfigValue);
            }
            catch (NumberFormatException ex) {
                log.warn("Invalid value '{}' provided for user context store expiry. Using default value: {}", (Object)expiryConfigValue, (Object)expiryTimeInSecs);
            }
        }
        return expiryTimeInSecs;
    }

    @Override
    public String get(String contextId) {
        return this.userContextMap.get(contextId);
    }

    @Override
    public void put(String contextId, String context) {
        this.userContextMap.put(contextId, context);
    }

    @Override
    public boolean containsKey(String contextId) {
        return this.userContextMap.containsKey(contextId);
    }

    @Override
    public void remove(String contextId) {
        this.userContextMap.remove(contextId);
    }
}

