/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.model;

import io.cellery.security.cell.sts.server.core.model.RequestContext;
import io.cellery.security.cell.sts.server.core.model.RequestDestination;
import io.cellery.security.cell.sts.server.core.model.RequestSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CellStsRequest {
    private String requestId;
    private RequestSource source;
    private RequestDestination destination;
    private RequestContext requestContext;
    private boolean isGatewayIncomingRequest;
    private Map<String, String> requestHeaders = new HashMap<String, String>();

    public RequestSource getSource() {
        return this.source;
    }

    public RequestDestination getDestination() {
        return this.destination;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public Map<String, String> getRequestHeaders() {
        return Collections.unmodifiableMap(this.requestHeaders);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public boolean isGatewayIncomingRequest() {
        return this.isGatewayIncomingRequest;
    }

    private CellStsRequest() {
    }

    public static class CellStsRequestBuilder {
        private String requestId;
        private RequestSource source;
        private RequestDestination destination;
        private RequestContext requestContext;
        private boolean isGatewayIncomingRequest;
        private Map<String, String> requestHeaders = new HashMap<String, String>();

        public CellStsRequestBuilder setSource(RequestSource source) {
            this.source = source;
            return this;
        }

        public CellStsRequestBuilder setDestination(RequestDestination destination) {
            this.destination = destination;
            return this;
        }

        public CellStsRequestBuilder setRequestContext(RequestContext requestContext) {
            this.requestContext = requestContext;
            return this;
        }

        public CellStsRequestBuilder setRequestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = requestHeaders;
            return this;
        }

        public CellStsRequestBuilder setRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public CellStsRequestBuilder setIsGatewayIncomingRequest(boolean isGatewayIncomingRequest) {
            this.isGatewayIncomingRequest = isGatewayIncomingRequest;
            return this;
        }

        public CellStsRequest build() {
            CellStsRequest request = new CellStsRequest();
            request.requestId = this.requestId;
            request.source = this.source;
            request.destination = this.destination;
            request.requestContext = this.requestContext;
            request.requestHeaders = this.requestHeaders;
            request.isGatewayIncomingRequest = this.isGatewayIncomingRequest;
            return request;
        }
    }
}

