/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.model;

import io.cellery.security.cell.sts.server.core.CellStsUtils;
import java.util.HashMap;

public class RequestDestination {
    private String cellName;
    private String workload;
    private boolean isExternalToCellery;

    private RequestDestination() {
    }

    public String getCellName() {
        return this.cellName;
    }

    public String getWorkload() {
        return this.workload;
    }

    public boolean isExternalToCellery() {
        return this.isExternalToCellery;
    }

    public String toString() {
        HashMap<String, String> configJson = new HashMap<String, String>();
        configJson.put("Cell Name", this.cellName);
        configJson.put("Workload", this.workload);
        return CellStsUtils.getPrettyPrintJson(configJson);
    }

    public static class RequestDestinationBuilder {
        private String cellName;
        private String workload;
        private boolean isExternalToCellery;

        public RequestDestinationBuilder setCellName(String cellName) {
            this.cellName = cellName;
            return this;
        }

        public RequestDestinationBuilder setWorkload(String workload) {
            this.workload = workload;
            return this;
        }

        public RequestDestinationBuilder setExternalToCellery(boolean externalToCellery) {
            this.isExternalToCellery = externalToCellery;
            return this;
        }

        public RequestDestination build() {
            RequestDestination destination = new RequestDestination();
            destination.cellName = this.cellName;
            destination.workload = this.workload;
            destination.isExternalToCellery = this.isExternalToCellery;
            return destination;
        }
    }
}

