/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.model;

import io.cellery.security.cell.sts.server.core.CellStsUtils;
import java.util.HashMap;

public class RequestSource {
    private String cellInstanceName;
    private String workload;

    private RequestSource() {
    }

    public String getCellInstanceName() {
        return this.cellInstanceName;
    }

    public String getWorkload() {
        return this.workload;
    }

    public String toString() {
        HashMap<String, String> configJson = new HashMap<String, String>();
        configJson.put("Cell Instance Name", this.cellInstanceName);
        configJson.put("Workload", this.workload);
        return CellStsUtils.getPrettyPrintJson(configJson);
    }

    public static class RequestSourceBuilder {
        private String cellInstanceName;
        private String workload;

        public RequestSourceBuilder setWorkload(String workload) {
            this.workload = workload;
            return this;
        }

        public RequestSourceBuilder setCellInstanceName(String cellInstanceName) {
            this.cellInstanceName = cellInstanceName;
            return this;
        }

        public RequestSource build() {
            RequestSource requestSource = new RequestSource();
            requestSource.cellInstanceName = this.cellInstanceName;
            requestSource.workload = this.workload;
            return requestSource;
        }
    }
}

