/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.model.config;

import io.cellery.security.cell.sts.server.core.CellStsUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CellStsConfiguration {
    private String stsEndpoint;
    private String username;
    private String password;
    private String cellName;
    private String globalJWKSEndpoint;
    private boolean signatureValidationEnabled;
    private boolean audienceValidationEnabled;
    private boolean issuerValidationEnabled;
    private boolean authorizationEnabled;
    private String stsOPAQueryPrefix;
    private List<String> unsecuredAPIS;
    private static CellStsConfiguration instance = new CellStsConfiguration();

    public List<String> getUnsecuredAPIS() {
        if (this.unsecuredAPIS == null) {
            return Collections.emptyList();
        }
        return this.unsecuredAPIS;
    }

    public void setUnsecuredAPIS(List<String> unsecuredAPIS) {
        this.unsecuredAPIS = unsecuredAPIS;
    }

    private CellStsConfiguration() {
    }

    public static CellStsConfiguration getInstance() {
        return instance;
    }

    public boolean isSignatureValidationEnabled() {
        return this.signatureValidationEnabled;
    }

    public CellStsConfiguration setSignatureValidationEnabled(boolean signatureValidationEnbled) {
        this.signatureValidationEnabled = signatureValidationEnbled;
        return this;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public CellStsConfiguration setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
        return this;
    }

    public String getSTSOPAQueryPrefix() {
        return this.stsOPAQueryPrefix;
    }

    public CellStsConfiguration setSTSOPAQueryPrefix(String stsOPAQueryPrefix) {
        this.stsOPAQueryPrefix = stsOPAQueryPrefix;
        return this;
    }

    public boolean isAudienceValidationEnabled() {
        return this.audienceValidationEnabled;
    }

    public CellStsConfiguration setAudienceValidationEnabled(boolean audienceValidationEnabled) {
        this.audienceValidationEnabled = audienceValidationEnabled;
        return this;
    }

    public boolean isIssuerValidationEnabled() {
        return this.issuerValidationEnabled;
    }

    public CellStsConfiguration setIssuerValidationEnabled(boolean issuerValidationEnabled) {
        this.issuerValidationEnabled = issuerValidationEnabled;
        return this;
    }

    public String getGlobalJWKEndpoint() {
        return this.globalJWKSEndpoint;
    }

    public CellStsConfiguration setGlobalJWKEndpoint(String globalJWKSEndpoint) {
        this.globalJWKSEndpoint = globalJWKSEndpoint;
        return this;
    }

    public String getStsEndpoint() {
        return this.stsEndpoint;
    }

    public CellStsConfiguration setStsEndpoint(String stsEndpoint) {
        this.stsEndpoint = stsEndpoint;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public CellStsConfiguration setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public CellStsConfiguration setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getCellName() {
        return this.cellName;
    }

    public CellStsConfiguration setCellName(String cellName) {
        this.cellName = cellName;
        return this;
    }

    public String toString() {
        HashMap<String, String> configJson = new HashMap<String, String>();
        configJson.put("Global STS Endpoint", this.stsEndpoint);
        configJson.put("Cell Name", this.cellName);
        return CellStsUtils.getPrettyPrintJson(configJson);
    }
}

