/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.service;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Status;
import com.nimbusds.jwt.JWTClaimsSet;
import io.cellery.security.cell.sts.server.core.CellStsUtils;
import io.cellery.security.cell.sts.server.core.STSTokenGenerator;
import io.cellery.security.cell.sts.server.core.generated.istio.mixer.v1.AttributesOuterClass;
import io.cellery.security.cell.sts.server.core.model.CellStsRequest;
import io.cellery.security.cell.sts.server.core.model.CellStsResponse;
import io.cellery.security.cell.sts.server.core.model.RequestContext;
import io.cellery.security.cell.sts.server.core.model.RequestDestination;
import io.cellery.security.cell.sts.server.core.model.RequestSource;
import io.cellery.security.cell.sts.server.core.service.CelleryCellSTSException;
import io.cellery.security.cell.sts.server.core.service.CelleryCellStsService;
import io.envoyproxy.envoy.api.v2.core.HeaderValue;
import io.envoyproxy.envoy.api.v2.core.HeaderValueOption;
import io.envoyproxy.envoy.service.auth.v2.AttributeContext;
import io.envoyproxy.envoy.service.auth.v2.AuthorizationGrpc;
import io.envoyproxy.envoy.service.auth.v2.CheckRequest;
import io.envoyproxy.envoy.service.auth.v2.CheckResponse;
import io.envoyproxy.envoy.service.auth.v2.OkHttpResponse;
import io.grpc.stub.StreamObserver;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class CelleryCellInterceptorService
extends AuthorizationGrpc.AuthorizationImplBase {
    private static final Logger log = LoggerFactory.getLogger(CelleryCellInterceptorService.class);
    private static final String REQUEST_ID = "request.id";
    private static final String CELL_NAME = "cell.name";
    private static final String REQUEST_ID_HEADER = "x-request-id";
    private static final String DESTINATION_HEADER = ":authority";
    private static final String ISTIO_ATTRIBUTES_HEADER = "x-istio-attributes";
    private static final String ISTIO_INGRESS_PREFIX = "istio-ingressgateway";
    protected CelleryCellStsService cellStsService;

    public CelleryCellInterceptorService(CelleryCellStsService cellStsService) throws CelleryCellSTSException {
        this.cellStsService = cellStsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void check(CheckRequest requestFromProxy, StreamObserver<CheckResponse> responseObserver) {
        CheckResponse responseToProxy;
        try {
            MDC.put(REQUEST_ID, this.getRequestId(requestFromProxy));
            MDC.put(CELL_NAME, CellStsUtils.getMyCellName());
            String destination = this.getDestination(requestFromProxy);
            log.debug("Request from Istio-Proxy (destination:{}):\n{}", (Object)destination, (Object)requestFromProxy);
            CellStsRequest cellStsRequest = this.buildCellStsRequest(requestFromProxy);
            AttributesOuterClass.Attributes attributesFromRequest = this.getAttributesFromRequest(requestFromProxy);
            Map<Object, Object> attributesMap = attributesFromRequest != null ? attributesFromRequest.getAttributesMap() : Collections.emptyMap();
            log.debug("Request Attributes: \n" + attributesMap);
            CellStsResponse cellStsResponse = new CellStsResponse();
            this.handleRequest(cellStsRequest, cellStsResponse);
            responseToProxy = CheckResponse.newBuilder().setStatus(Status.newBuilder().setCode(0).build()).setOkResponse(this.buildOkHttpResponseWithHeaders(cellStsResponse.getResponseHeaders())).build();
            log.debug("Response to istio-proxy (destination:{}):\n{}", (Object)destination, (Object)responseToProxy);
        }
        catch (CelleryCellSTSException e) {
            log.error("Error while handling request from istio-proxy to (destination:{})", (Object)this.getDestination(requestFromProxy), (Object)e);
            responseToProxy = this.buildErrorResponse();
        }
        finally {
            MDC.clear();
        }
        responseObserver.onNext(responseToProxy);
        responseObserver.onCompleted();
    }

    protected abstract void handleRequest(CellStsRequest var1, CellStsResponse var2) throws CelleryCellSTSException;

    private CheckResponse buildErrorResponse() {
        return CheckResponse.newBuilder().setStatus(Status.newBuilder().setCode(7).build()).build();
    }

    private OkHttpResponse buildOkHttpResponseWithHeaders(Map<String, String> headers) {
        OkHttpResponse.Builder builder = OkHttpResponse.newBuilder();
        headers.forEach((key, value) -> builder.addHeaders(this.buildHeader((String)key, (String)value)));
        return builder.build();
    }

    private HeaderValueOption buildHeader(String headerName, String headerValue) {
        return HeaderValueOption.newBuilder().setHeader(HeaderValue.newBuilder().setKey(headerName).setValue(headerValue)).build();
    }

    private String getRequestId(CheckRequest request) throws CelleryCellSTSException {
        String id = request.getAttributes().getRequest().getHttp().getHeadersMap().get(REQUEST_ID_HEADER);
        if (StringUtils.isBlank(id)) {
            throw new CelleryCellSTSException("Request Id cannot be found in the header: x-request-id");
        }
        return id;
    }

    private String getDestination(CheckRequest request) {
        AttributesOuterClass.Attributes.AttributeValue attributeValue;
        String destination = "";
        AttributesOuterClass.Attributes attributesFromRequest = this.getAttributesFromRequest(request);
        if (attributesFromRequest != null && (attributeValue = attributesFromRequest.getAttributesMap().get("destination.service.name")) != null) {
            destination = attributeValue.getStringValue();
        }
        if (StringUtils.isEmpty(destination)) {
            log.debug("Destination cannot be found in request attributes.");
            destination = request.getAttributes().getRequest().getHttp().getHeadersMap().get(DESTINATION_HEADER);
            if (StringUtils.isBlank(destination)) {
                destination = request.getAttributes().getRequest().getHttp().getHost();
                log.debug("Destination is picked from host value in the request.");
            }
        }
        return destination;
    }

    protected CellStsRequest buildCellStsRequest(CheckRequest requestFromProxy) throws CelleryCellSTSException {
        return this.getCellStsRequestBuilder(requestFromProxy).build();
    }

    protected CellStsRequest.CellStsRequestBuilder getCellStsRequestBuilder(CheckRequest requestFromProxy) throws CelleryCellSTSException {
        RequestDestination destination = this.buildRequestDestination(requestFromProxy);
        return new CellStsRequest.CellStsRequestBuilder().setRequestId(this.getRequestId(requestFromProxy)).setRequestHeaders(requestFromProxy.getAttributes().getRequest().getHttp().getHeaders()).setSource(this.buildRequestSource(requestFromProxy, destination.getWorkload())).setDestination(destination).setRequestContext(this.buildRequestContext(requestFromProxy));
    }

    private AttributesOuterClass.Attributes getAttributesFromRequest(CheckRequest requestFromProxy) {
        String mixerAttributesHeaderValue = this.getMixerAttributesHeader(requestFromProxy);
        if (StringUtils.isNotBlank(mixerAttributesHeaderValue)) {
            byte[] decodeHeader = Base64.getDecoder().decode(mixerAttributesHeaderValue.getBytes(StandardCharsets.UTF_8));
            try {
                return AttributesOuterClass.Attributes.parseFrom(decodeHeader);
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Error while trying to decode mixer attributes from '{}' header", (Object)ISTIO_ATTRIBUTES_HEADER);
            }
        }
        return null;
    }

    private String getMixerAttributesHeader(CheckRequest requestFromProxy) {
        return requestFromProxy.getAttributes().getRequest().getHttp().getHeadersMap().get(ISTIO_ATTRIBUTES_HEADER);
    }

    private RequestContext buildRequestContext(CheckRequest checkRequest) {
        AttributeContext.HttpRequest httpRequest = checkRequest.getAttributes().getRequest().getHttp();
        return new RequestContext().setHost(httpRequest.getHost()).setProtocol(httpRequest.getProtocol()).setMethod(httpRequest.getMethod()).setPath(httpRequest.getPath());
    }

    private RequestSource buildRequestSource(CheckRequest checkRequest, String destinationWorkload) {
        AttributesOuterClass.Attributes.AttributeValue sourceId;
        AttributesOuterClass.Attributes attributesFromRequest = this.getAttributesFromRequest(checkRequest);
        RequestSource.RequestSourceBuilder requestSourceBuilder = new RequestSource.RequestSourceBuilder();
        if (attributesFromRequest != null && (sourceId = attributesFromRequest.getAttributesMap().get("source.uid")) != null) {
            String sourceUid = sourceId.getStringValue();
            String sourceWorkloadName = sourceUid.replace("kubernetes://", "");
            String sourceCell = this.extractCellNameFromWorkloadName(sourceWorkloadName);
            if (this.isCompositeSource(checkRequest, destinationWorkload)) {
                sourceCell = "composite";
            }
            requestSourceBuilder.setWorkload(sourceWorkloadName).setCellInstanceName(sourceCell);
        }
        return requestSourceBuilder.build();
    }

    private boolean isCompositeSource(CheckRequest checkRequest, String destinationWorkload) {
        Map<String, String> requestHeaders = checkRequest.getAttributes().getRequest().getHttp().getHeaders();
        String token = CellStsUtils.extractJwtFromAuthzHeader(CellStsUtils.getAuthorizationHeaderValue(requestHeaders));
        if (StringUtils.isEmpty(token)) {
            log.debug("No token received. Hence source shouldn't be a composite.");
            return false;
        }
        try {
            JWTClaimsSet jwtClaims = STSTokenGenerator.getJWTClaims(token);
            String destination = jwtClaims.getStringClaim("destination");
            String issuerCell = jwtClaims.getStringClaim("cellInstanceName");
            if (destinationWorkload.equalsIgnoreCase(destination) && "composite".equalsIgnoreCase(issuerCell)) {
                log.debug("Source is a composite");
                return true;
            }
        }
        catch (CelleryCellSTSException | ParseException e) {
            log.debug("Couldn't derive source from token");
        }
        log.debug("Source is not a composite.");
        return false;
    }

    private String extractCellNameFromWorkloadName(String workloadName) {
        if (StringUtils.isNotEmpty(workloadName) && workloadName.startsWith(ISTIO_INGRESS_PREFIX) || !workloadName.contains("--")) {
            return null;
        }
        return workloadName.split("--")[0];
    }

    private RequestDestination buildRequestDestination(CheckRequest checkRequest) {
        RequestDestination.RequestDestinationBuilder destinationBuilder = new RequestDestination.RequestDestinationBuilder();
        String destinationWorkloadName = this.getDestination(checkRequest);
        if (StringUtils.isNotBlank(destinationWorkloadName)) {
            destinationBuilder.setWorkload(destinationWorkloadName);
        }
        if (CellStsUtils.isWorkloadExternalToCellery(destinationWorkloadName)) {
            destinationBuilder.setExternalToCellery(true);
        } else {
            destinationBuilder.setCellName(this.extractCellNameFromWorkloadName(destinationWorkloadName));
        }
        return destinationBuilder.build();
    }
}

