/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.service;

import io.cellery.security.cell.sts.server.authorization.AuthorizationFailedException;
import io.cellery.security.cell.sts.server.core.CellStsUtils;
import io.cellery.security.cell.sts.server.core.context.store.UserContextStore;
import io.cellery.security.cell.sts.server.core.exception.CellSTSRequestValidationFailedException;
import io.cellery.security.cell.sts.server.core.model.CellStsRequest;
import io.cellery.security.cell.sts.server.core.model.CellStsResponse;
import io.cellery.security.cell.sts.server.core.model.config.CellStsConfiguration;
import io.cellery.security.cell.sts.server.core.service.CelleryCellSTSException;
import io.cellery.security.cell.sts.server.core.service.CelleryCellStsService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelleryGWSTSService
extends CelleryCellStsService {
    private static final Logger log = LoggerFactory.getLogger(CelleryGWSTSService.class);

    public CelleryGWSTSService(UserContextStore contextStore, UserContextStore localContextStore) throws CelleryCellSTSException {
        super(contextStore, localContextStore);
    }

    @Override
    public void handleInboundRequest(CellStsRequest cellStsRequest, CellStsResponse cellStsResponse) throws CelleryCellSTSException {
        String requestId = cellStsRequest.getRequestId();
        if (log.isDebugEnabled()) {
            log.debug("Request reached gateway sidecar.");
        }
        try {
            boolean authenticationRequired = REQUEST_VALIDATOR.isAuthenticationRequired(cellStsRequest);
            if (!authenticationRequired) {
                this.attachToken(cellStsRequest, cellStsResponse);
                return;
            }
            log.debug("Authentication is required for the request ID: {} ", (Object)requestId);
        }
        catch (CellSTSRequestValidationFailedException e) {
            throw new CelleryCellSTSException("Error while evaluating authentication requirement", e);
        }
        String callerCell = cellStsRequest.getSource().getCellInstanceName();
        log.debug("Caller cell : {}", (Object)callerCell);
        String jwt = this.getUserContextJwt(cellStsRequest);
        log.debug("Incoming JWT : " + jwt);
        this.handleRequestToMicroGW(cellStsRequest, requestId, jwt);
        try {
            AUTHORIZATION_SERVICE.authorize(cellStsRequest, jwt);
        }
        catch (AuthorizationFailedException e) {
            throw new CelleryCellSTSException("Authorization failure", e);
        }
        this.attachToken(cellStsRequest, cellStsResponse);
        log.info("Gateway request processing ended successfully for request: {}", (Object)requestId);
    }

    @Override
    protected void attachToken(CellStsRequest cellStsRequest, CellStsResponse cellStsResponse) throws CelleryCellSTSException {
        String stsToken = this.exchangeToInternalToken(cellStsRequest);
        if (StringUtils.isEmpty(stsToken)) {
            throw new CelleryCellSTSException("No JWT token received from the STS endpoint: " + CellStsConfiguration.getInstance().getStsEndpoint());
        }
        log.debug("Attaching jwt to gateway request : {}", (Object)stsToken);
        if (cellStsRequest.getRequestHeaders().get("x-cellery-auth-subject") != null) {
            log.info("Found user in outgoing request");
        }
        cellStsResponse.addResponseHeader("cellery-authorization", "Bearer " + stsToken);
    }

    protected String exchangeToInternalToken(CellStsRequest request) throws CelleryCellSTSException {
        String requestId = request.getRequestId();
        log.debug("Request with ID: {} to micro gateway from {}", (Object)requestId, (Object)request.getSource());
        if (StringUtils.isNotEmpty(this.localContextStore.get(requestId))) {
            log.debug("Found an already existing local token issued for same request on a different occurance");
            return this.localContextStore.get(requestId);
        }
        String jwt = this.userContextStore.get(requestId);
        if (StringUtils.isEmpty(jwt)) {
            return this.getTokenFromLocalSTS(CellStsUtils.getMyCellName(), request.getDestination().getWorkload());
        }
        this.userContextStore.remove(requestId);
        return this.getTokenFromLocalSTS(jwt, CellStsUtils.getMyCellName(), request.getDestination().getWorkload());
    }
}

