/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.validators;

import io.cellery.security.cell.sts.server.core.CellStsUtils;
import java.util.Arrays;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class CelleryHostnameVerifier
implements HostnameVerifier {
    private HostnameVerifier hostnameVerifier;
    private boolean verifyHostname;
    private static final String HOSTNAME_VERIFICATION_ENABLED = "ENABLE_HOSTNAME_VERIFICATION";
    private static final String[] LOCALHOSTS = new String[]{"::1", "127.0.0.1", "localhost", "localhost.localdomain"};
    private static final String[] CELLERY_HOSTS = new String[]{"gateway.cellery-system", "idp.cellery-system", "wso2-apim", "wso2-apim-gateway"};

    public CelleryHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        this.verifyHostname = Boolean.parseBoolean(CellStsUtils.resolveSystemVariable(HOSTNAME_VERIFICATION_ENABLED));
    }

    static boolean containsHost(String host, String[] escapedHosts) {
        int x;
        String string = host = host != null ? host.trim().toLowerCase(Locale.US) : "";
        if (host.startsWith("::1") && (x = host.lastIndexOf(37)) >= 0) {
            host = host.substring(0, x);
        }
        return (x = Arrays.binarySearch(escapedHosts, host)) >= 0;
    }

    @Override
    public boolean verify(String host, SSLSession sslSession) {
        if (!this.verifyHostname) {
            return true;
        }
        if (CelleryHostnameVerifier.containsHost(host, LOCALHOSTS) || CelleryHostnameVerifier.containsHost(host, CELLERY_HOSTS)) {
            return true;
        }
        return this.hostnameVerifier.verify(host, sslSession);
    }
}

