/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.validators;

import io.cellery.security.cell.sts.server.core.CellStsUtils;
import io.cellery.security.cell.sts.server.core.service.CelleryCellSTSException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CelleryTrustManager
implements X509TrustManager {
    public static final String TRUST_CERTS_DEFAULT_LOCATION = "/etc/certs/trusted-certs";
    public static final String TRUST_CERTS_LOCATION_ENV = "TRUSTED_CERTS_LOCATION";
    public String trustCertsLocation = "/etc/certs/trusted-certs";
    private static Log log = LogFactory.getLog(CelleryTrustManager.class);
    private X509TrustManager defaultTrustManager;
    private X509TrustManager trustManager;
    private static final String VALIDATE_SERVER_CERT = "VALIDATE_SERVER_CERT";
    private boolean validateServerCertificate = Boolean.parseBoolean(CellStsUtils.resolveSystemVariable("VALIDATE_SERVER_CERT"));
    KeyStore keyStore;

    public CelleryTrustManager() throws CelleryCellSTSException {
        String customTrustCertsLocation = CellStsUtils.resolveSystemVariable(TRUST_CERTS_LOCATION_ENV);
        if (StringUtils.isNotEmpty(customTrustCertsLocation)) {
            this.trustCertsLocation = customTrustCertsLocation;
        }
        log.info("validate server certificate is set to : " + this.validateServerCertificate);
        this.setupTrustManager();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
        if (!this.validateServerCertificate) {
            return;
        }
        try {
            this.defaultTrustManager.checkServerTrusted(x509Certificates, s2);
        }
        catch (CertificateException e) {
            this.trustManager.checkServerTrusted(x509Certificates, s2);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
        if (!this.validateServerCertificate) {
            return;
        }
        try {
            this.defaultTrustManager.checkServerTrusted(x509Certificates, s2);
        }
        catch (CertificateException e) {
            this.trustManager.checkServerTrusted(x509Certificates, s2);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    private void setupTrustManager() throws CelleryCellSTSException {
        this.findDefaultTrustManager();
        this.setCustomTrustManager();
    }

    private void findDefaultTrustManager() throws CelleryCellSTSException {
        TrustManagerFactory trustManagerFactory = null;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            for (int i = 0; i < trustManagers.length; ++i) {
                TrustManager t = trustManagers[i];
                if (!(t instanceof X509TrustManager)) continue;
                this.defaultTrustManager = (X509TrustManager)t;
                return;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new CelleryCellSTSException("Error while setting trust manager", e);
        }
        throw new CelleryCellSTSException("No registered trust manager found");
    }

    private void setCustomTrustManager() throws CelleryCellSTSException {
        TrustManagerFactory trustManagerFactory = null;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.addCertificates();
            trustManagerFactory.init(this.keyStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            for (int i = 0; i < trustManagers.length; ++i) {
                TrustManager t = trustManagers[i];
                if (!(t instanceof X509TrustManager)) continue;
                this.trustManager = (X509TrustManager)t;
                return;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new CelleryCellSTSException("Error while setting trust manager", e);
        }
        throw new CelleryCellSTSException("No registered trust manager found");
    }

    private void addCertificates() throws CelleryCellSTSException {
        try {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.keyStore.load(null);
            this.readCertificates();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new CelleryCellSTSException("Error while creating empty keystore", e);
        }
    }

    private List<X509Certificate> readCertificates() throws CelleryCellSTSException {
        File folder = new File(this.trustCertsLocation);
        File[] files = folder.listFiles();
        ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>();
        if (files != null) {
            Arrays.stream(files).forEach(file -> {
                block16: {
                    try {
                        if (StringUtils.isNotEmpty(file.getName()) && file.getName().endsWith(".pem")) {
                            CertificateFactory fact = CertificateFactory.getInstance("X.509");
                            try (FileInputStream fileInputStream = new FileInputStream((File)file);){
                                Collection<? extends Certificate> certificates = fact.generateCertificates(fileInputStream);
                                if (certificates != null) {
                                    certificates.stream().forEach(certificate -> {
                                        X509Certificate x509Certificate = (X509Certificate)certificate;
                                        try {
                                            this.keyStore.setCertificateEntry(x509Certificate.getIssuerDN().getName(), x509Certificate);
                                        }
                                        catch (KeyStoreException e) {
                                            log.error("Error while adding certificate s {} " + certificate.toString(), e);
                                        }
                                        trustedCerts.add(x509Certificate);
                                        log.debug("Added to trust store: " + x509Certificate.getIssuerDN().getName());
                                    });
                                }
                                break block16;
                            }
                        }
                        log.debug("Found a non certificate file : " + file.getName());
                    }
                    catch (IOException | CertificateException e) {
                        log.error("Error while adding trusted certificte from file : " + file, e);
                    }
                }
            });
        }
        return trustedCerts;
    }
}

