/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.validators;

import io.cellery.security.cell.sts.server.core.CelleryCellSTSServer;
import io.cellery.security.cell.sts.server.core.exception.CellSTSRequestValidationFailedException;
import io.cellery.security.cell.sts.server.core.model.CellStsRequest;
import io.cellery.security.cell.sts.server.core.model.config.CellStsConfiguration;
import io.cellery.security.cell.sts.server.core.validators.CellSTSRequestValidator;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCellSTSReqValidator
implements CellSTSRequestValidator {
    private static final Logger log = LoggerFactory.getLogger(CelleryCellSTSServer.class);

    @Override
    public void validate(CellStsRequest cellStsRequest) throws CellSTSRequestValidationFailedException {
        String subject = cellStsRequest.getRequestHeaders().get("x-cellery-auth-subject");
        if (StringUtils.isNotBlank(subject)) {
            throw new CellSTSRequestValidationFailedException("A subject header is found in the inbound request, before security validation: " + subject);
        }
    }

    @Override
    public boolean isAuthenticationRequired(CellStsRequest cellStsRequest) throws CellSTSRequestValidationFailedException {
        String path = cellStsRequest.getRequestContext().getPath();
        Optional<String> unProtectedResult = CellStsConfiguration.getInstance().getUnsecuredAPIS().stream().filter(unProtectedPath -> DefaultCellSTSReqValidator.match(path, unProtectedPath)).findAny();
        log.info("Validating isAuthenticaitonRequered for context: {}", (Object)path);
        log.info(CellStsConfiguration.getInstance().getUnsecuredAPIS().toString());
        if (unProtectedResult.isPresent()) {
            log.info("Unprotected resource match found. Hence returning false");
            return false;
        }
        return true;
    }

    private static boolean match(String url, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m3 = p.matcher(url);
        return m3.find();
    }
}

