/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.validators;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.proc.SimpleSecurityContext;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import io.cellery.security.cell.sts.server.core.exception.TokenValidationFailureException;
import io.cellery.security.cell.sts.server.core.validators.JWKSourceDataProvider;
import io.cellery.security.cell.sts.server.core.validators.JWTSignatureValidator;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JWKSBasedJWTValidator
implements JWTSignatureValidator {
    private static final Log log = LogFactory.getLog(JWKSBasedJWTValidator.class);
    private ConfigurableJWTProcessor<SecurityContext> jwtProcessor = new DefaultJWTProcessor<SecurityContext>();

    @Override
    public boolean validateSignature(String jwtString, String jwksUri, String algorithm, Map<String, Object> opts) throws TokenValidationFailureException {
        try {
            JWT jwt = JWTParser.parse(jwtString);
            return this.validateSignature(jwt, jwksUri, algorithm, opts);
        }
        catch (ParseException e) {
            throw new TokenValidationFailureException("Error occurred while parsing JWT string.", e);
        }
    }

    @Override
    public boolean validateSignature(JWT jwt, String jwksUri, String algorithm, Map<String, Object> opts) throws TokenValidationFailureException {
        if (log.isDebugEnabled()) {
            log.debug("validating JWT signature using jwks_uri: " + jwksUri + " , for signing algorithm: " + algorithm);
        }
        try {
            this.setJWKeySelector(jwksUri, algorithm);
            SimpleSecurityContext securityContext = null;
            if (opts != null && !opts.isEmpty()) {
                securityContext = new SimpleSecurityContext();
                securityContext.putAll(opts);
            }
            if (jwt instanceof PlainJWT) {
                this.jwtProcessor.process((PlainJWT)jwt, (SecurityContext)securityContext);
            } else if (jwt instanceof SignedJWT) {
                this.jwtProcessor.process((SignedJWT)jwt, (SecurityContext)securityContext);
            } else if (jwt instanceof EncryptedJWT) {
                this.jwtProcessor.process((EncryptedJWT)jwt, (SecurityContext)securityContext);
            } else {
                this.jwtProcessor.process(jwt, (SecurityContext)securityContext);
            }
            return true;
        }
        catch (MalformedURLException e) {
            throw new TokenValidationFailureException("Provided jwks_uri is malformed.", e);
        }
        catch (JOSEException e) {
            throw new TokenValidationFailureException("Signature validation failed for the provided JWT.", e);
        }
        catch (BadJOSEException e) {
            throw new TokenValidationFailureException("Signature validation failed for the provided JWT", e);
        }
    }

    private void setJWKeySelector(String jwksUri, String algorithm) throws MalformedURLException {
        RemoteJWKSet<SecurityContext> keySource = JWKSourceDataProvider.getInstance().getJWKSource(jwksUri);
        JWSAlgorithm expectedJWSAlg = JWSAlgorithm.parse(algorithm);
        JWSVerificationKeySelector<SecurityContext> keySelector = new JWSVerificationKeySelector<SecurityContext>(expectedJWSAlg, keySource);
        this.jwtProcessor.setJWSKeySelector(keySelector);
    }
}

