/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.core.validators;

import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import io.cellery.security.cell.sts.server.core.exception.TokenValidationFailureException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JWKSourceDataProvider {
    private static final int DEFAULT_HTTP_CONNECTION_TIMEOUT = 1000;
    private static final int DEFAULT_HTTP_READ_TIMEOUT = 1000;
    private static final Log log = LogFactory.getLog(JWKSourceDataProvider.class);
    private static JWKSourceDataProvider jwkSourceDataProvider = new JWKSourceDataProvider();
    private Map<String, RemoteJWKSet<SecurityContext>> jwkSourceMap = new ConcurrentHashMap<String, RemoteJWKSet<SecurityContext>>();

    private JWKSourceDataProvider() {
    }

    public static JWKSourceDataProvider getInstance() {
        return jwkSourceDataProvider;
    }

    public RemoteJWKSet<SecurityContext> getJWKSource(String jwksUri) throws MalformedURLException {
        RemoteJWKSet<SecurityContext> jwkSet = this.jwkSourceMap.get(jwksUri);
        if (jwkSet == null) {
            jwkSet = this.retrieveJWKSFromJWKSEndpoint(jwksUri);
            this.jwkSourceMap.put(jwksUri, jwkSet);
        }
        return jwkSet;
    }

    public Map<String, RemoteJWKSet<SecurityContext>> getJwkSourceMap() {
        return this.jwkSourceMap;
    }

    public void refreshJWKSResource(String jwksUri) throws TokenValidationFailureException {
        try {
            this.jwkSourceMap.remove(jwksUri);
            RemoteJWKSet<SecurityContext> jwkSet = this.retrieveJWKSFromJWKSEndpoint(jwksUri);
            this.jwkSourceMap.put(jwksUri, jwkSet);
        }
        catch (MalformedURLException e) {
            throw new TokenValidationFailureException("Provided URI is malformed. jwks_uri: " + jwksUri, e);
        }
    }

    private RemoteJWKSet<SecurityContext> retrieveJWKSFromJWKSEndpoint(String jwksUri) throws MalformedURLException {
        int connectionTimeout = 1000;
        int readTimeout = 1000;
        int sizeLimit = 51200;
        DefaultResourceRetriever resourceRetriever = new DefaultResourceRetriever(connectionTimeout, readTimeout, sizeLimit);
        return new RemoteJWKSet<SecurityContext>(new URL(jwksUri), resourceRetriever);
    }
}

