/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.jwks;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import io.cellery.security.cell.sts.server.utils.CertificateUtils;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWKSResponseBuilder {
    private static final Logger log = LoggerFactory.getLogger(JWKSResponseBuilder.class);

    public static String buildResponse(PublicKey publicKey, Certificate certificate) throws CertificateException, NoSuchAlgorithmException, ParseException {
        JSONArray jwksArray = new JSONArray();
        JSONObject jwksJson = new JSONObject();
        if (publicKey instanceof RSAPublicKey) {
            RSAKey.Builder jwk = new RSAKey.Builder((RSAPublicKey)publicKey);
            jwk.keyID(CertificateUtils.getThumbPrint(certificate));
            jwk.algorithm(JWSAlgorithm.RS256);
            jwk.keyUse(KeyUse.parse("sig"));
            jwksArray.put(jwk.build().toJSONObject());
            jwksJson.put("keys", jwksArray);
            log.debug(jwksJson.toString());
        }
        return jwksJson.toString();
    }
}

