/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.jwks;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import io.cellery.security.cell.sts.server.jwks.JWKSResponseBuilder;
import io.cellery.security.cell.sts.server.jwks.KeyResolver;
import io.cellery.security.cell.sts.server.jwks.KeyResolverException;
import io.cellery.security.cell.sts.server.utils.CertificateUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWKSServer {
    private static final Logger log = LoggerFactory.getLogger(JWKSServer.class);
    private static KeyResolver keyResolver = CertificateUtils.getKeyResolver();
    private int port;

    public JWKSServer(int port) {
        this.port = port;
    }

    public void startServer() throws IOException, KeyResolverException {
        HttpServer server = HttpServer.create(new InetSocketAddress(this.port), 0);
        HttpContext context = server.createContext("/");
        context.setHandler(JWKSServer::handleRequest);
        server.start();
        log.info("JWKS endpoint started in port : {}", (Object)this.port);
    }

    private static void handleRequest(HttpExchange exchange) throws IOException {
        String response;
        try {
            response = JWKSResponseBuilder.buildResponse(keyResolver.getPublicKey(), keyResolver.getCertificate());
        }
        catch (KeyResolverException | NoSuchAlgorithmException | CertificateException | ParseException e) {
            throw new IOException("Error while building response from JWKS endpoint");
        }
        exchange.sendResponseHeaders(200, response.getBytes(StandardCharsets.UTF_8).length);
        OutputStream os = exchange.getResponseBody();
        os.write(response.getBytes(StandardCharsets.UTF_8));
        os.close();
    }
}

