/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.jwks;

import io.cellery.security.cell.sts.server.jwks.KeyResolverException;
import io.cellery.security.cell.sts.server.jwks.StaticKeyResolver;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class SPIFFEKeyResolver
extends StaticKeyResolver {
    private static String publicKeyString = "-----BEGIN CERTIFICATE-----\nMIIDJjCCAg6gAwIBAgIRANmawRKKvf2ZSIXfzIXpj9cwDQYJKoZIhvcNAQELBQAw\nHDEaMBgGA1UEChMRazhzLmNsdXN0ZXIubG9jYWwwHhcNMTgxMTIzMTAyNDU2WhcN\nMTkwMjIxMTAyNDU2WjALMQkwBwYDVQQKEwAwggEiMA0GCSqGSIb3DQEBAQUAA4IB\nDwAwggEKAoIBAQCdWHtkvQop9FJrPQ6MgIkdxBBSSyuT38VXxkfp7bx8bU/HEImg\nUUpuH60MXJSAWh3CQ2lbjcwCupt94QSDu3bL9qfhekbRcrduwY6lZWD+nx9Yy3gL\n8dukUozFJHAUYIpwa4Sjjrt28zWxMQnQ6/tGqUPXzD2NYZyQmQM0ZngUq/34ypoz\nCUrWaPCsHnYYSKfHPb0xcoCSg3vZpNlsyqX8qaisCEFSVI4psuB6ktGBJ2bVfhQS\n3RlvncpEd+6gaKrTS3i9b4hdvhPHOkwpvyF9jkNu4QWTRmq1/7j+ptLvNatqNEIW\nIPO0McQcnMAvwb1IuuQQKmbgmR36d/4m9yuNAgMBAAGjdDByMA4GA1UdDwEB/wQE\nAwIFoDAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwDAYDVR0TAQH/BAIw\nADAzBgNVHREELDAqhihzcGlmZmU6Ly9jbHVzdGVyLmxvY2FsL25zL2Zvby9zYS9k\nZWZhdWx0MA0GCSqGSIb3DQEBCwUAA4IBAQBD24+bdQ6n43soOZsjqf1OA3/3WNiE\nIL+GANg1jDDjYJw+gjl2RNa+EJNoHGdJ9x4X3U9dFkHzSF7/sa4Wr5wa5Ztkn9dN\nPS7srNjplfoeIDW7y9uqlept1hU/8LL9J4PKzHWQtRYrbwmyJ1cql3rubrGSRjSu\nnO7xDZGl6H33UhWnFT3zJYPJ7+mY6jxgyhYxoNylC1pQFloWGmjf3Q33LYXcawJN\n9qqHgRbvo9RTMHrPqk/9mDl5KLhQr//d3K+rBfO9A7MjAaKk+/1SQHCd9DwLyAlL\ngZwKV3qnWX9WAevQJPHiQ0KIBAUwygm8iUlp+6x7fpCIrH/sKZCFpzNa\n-----END CERTIFICATE-----\n";

    @Override
    public PrivateKey getPrivateKey() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() throws KeyResolverException {
        try {
            return SPIFFEKeyResolver.buildCertificate(publicKeyString).getPublicKey();
        }
        catch (CertificateException e) {
            throw new KeyResolverException("Error while retrieving public key", e);
        }
    }

    @Override
    public X509Certificate getCertificate() throws KeyResolverException {
        try {
            return (X509Certificate)SPIFFEKeyResolver.buildCertificate(publicKeyString);
        }
        catch (CertificateException e) {
            throw new KeyResolverException("Error while building certificate", e);
        }
    }
}

