/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.jwks;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import sun.security.tools.keytool.CertAndKeyGen;
import sun.security.x509.X500Name;

public class SelfSignedCertGenerator {
    private PrivateKey privateKey;
    private X509Certificate certificate;
    private PublicKey publicKey;

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public SelfSignedCertGenerator(String commonName) throws Exception {
        CertAndKeyGen keyGen = new CertAndKeyGen("RSA", "SHA1WithRSA", null);
        keyGen.generate(2048);
        this.privateKey = keyGen.getPrivateKey();
        this.publicKey = keyGen.getPublicKey();
        X509Certificate[] chain = new X509Certificate[]{keyGen.getSelfCertificate(new X500Name("CN=" + commonName), 31536000L)};
        this.certificate = chain[0];
    }
}

