/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.jwks;

import io.cellery.security.cell.sts.server.jwks.KeyResolver;
import io.cellery.security.cell.sts.server.jwks.KeyResolverException;
import io.cellery.security.cell.sts.server.jwks.SelfSignedCertGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class SelfSignedKeyResolver
implements KeyResolver {
    SelfSignedCertGenerator selfSignedCertGenerator;

    public SelfSignedKeyResolver(String commonName) throws KeyResolverException {
        try {
            this.selfSignedCertGenerator = new SelfSignedCertGenerator(commonName);
        }
        catch (Exception e) {
            throw new KeyResolverException("Error while resolving keys", e);
        }
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.selfSignedCertGenerator.getPrivateKey();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.selfSignedCertGenerator.getPublicKey();
    }

    @Override
    public X509Certificate getCertificate() {
        return this.selfSignedCertGenerator.getCertificate();
    }
}

