/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.utils;

import io.cellery.security.cell.sts.server.jwks.FileBasedKeyResolver;
import io.cellery.security.cell.sts.server.jwks.KeyResolver;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtils {
    private static final Logger log = LoggerFactory.getLogger(CertificateUtils.class);
    private static KeyResolver keyResolver = new FileBasedKeyResolver();

    public static String getThumbPrint(Certificate certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest digestValue = MessageDigest.getInstance("SHA-1");
        byte[] der = certificate.getEncoded();
        digestValue.update(der);
        byte[] digestInBytes = digestValue.digest();
        String publicCertThumbprint = CertificateUtils.hexify(digestInBytes);
        return new String(new Base64(0, null, true).encode(publicCertThumbprint.getBytes(Charset.forName("UTF-8"))), Charset.forName("UTF-8"));
    }

    public static String hexify(byte[] bytes) {
        if (bytes == null) {
            String errorMsg = "Invalid byte array: 'NULL'";
            throw new IllegalArgumentException(errorMsg);
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }

    public static KeyResolver getKeyResolver() {
        return keyResolver;
    }
}

