/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingChannelBuilder;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.alts.CheckGcpEnvironment;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsClientOptions;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.alts.internal.AltsTsiHandshaker;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ProxyParameters;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsChannelBuilder
extends ForwardingChannelBuilder<AltsChannelBuilder> {
    private final NettyChannelBuilder delegate;
    private final AltsClientOptions.Builder handshakerOptionsBuilder = new AltsClientOptions.Builder();
    private TcpfFactory tcpfFactoryForTest;
    private boolean enableUntrustedAlts;

    public static final AltsChannelBuilder forTarget(String target) {
        return new AltsChannelBuilder(target);
    }

    public static AltsChannelBuilder forAddress(String name, int port) {
        return AltsChannelBuilder.forTarget(GrpcUtil.authorityFromHostAndPort(name, port));
    }

    private AltsChannelBuilder(String target) {
        this.delegate = NettyChannelBuilder.forTarget(target).keepAliveTime(20L, TimeUnit.SECONDS).keepAliveTimeout(10L, TimeUnit.SECONDS).keepAliveWithoutCalls(true);
        this.handshakerOptionsBuilder.setRpcProtocolVersions(RpcProtocolVersionsUtil.getRpcProtocolVersions());
    }

    public AltsChannelBuilder withSecureNamingTarget(String targetName) {
        this.handshakerOptionsBuilder.setTargetName(targetName);
        return this;
    }

    public AltsChannelBuilder addTargetServiceAccount(String targetServiceAccount) {
        this.handshakerOptionsBuilder.addTargetServiceAccount(targetServiceAccount);
        return this;
    }

    public AltsChannelBuilder enableUntrustedAltsForTesting() {
        this.enableUntrustedAlts = true;
        return this;
    }

    public AltsChannelBuilder setHandshakerAddressForTesting(String handshakerAddress) {
        HandshakerServiceChannel.setHandshakerAddressForTesting(handshakerAddress);
        return this;
    }

    protected NettyChannelBuilder delegate() {
        return this.delegate;
    }

    @Override
    public ManagedChannel build() {
        CheckGcpEnvironment.check(this.enableUntrustedAlts);
        TcpfFactory tcpfFactory = new TcpfFactory();
        InternalNettyChannelBuilder.setDynamicTransportParamsFactory(this.delegate(), tcpfFactory);
        this.tcpfFactoryForTest = tcpfFactory;
        return new AltsChannel(this.delegate().build());
    }

    @Nullable
    @VisibleForTesting
    InternalNettyChannelBuilder.TransportCreationParamsFilterFactory getTcpfFactoryForTest() {
        return this.tcpfFactoryForTest;
    }

    @Nullable
    @VisibleForTesting
    AltsClientOptions getAltsClientOptionsForTest() {
        if (this.tcpfFactoryForTest == null) {
            return null;
        }
        return this.tcpfFactoryForTest.handshakerOptions;
    }

    static final class AltsChannel
    extends ManagedChannel {
        private final ManagedChannel delegate;

        AltsChannel(ManagedChannel delegate) {
            this.delegate = delegate;
        }

        @Override
        public ConnectivityState getState(boolean requestConnection) {
            return this.delegate.getState(requestConnection);
        }

        @Override
        public void notifyWhenStateChanged(ConnectivityState source, Runnable callback) {
            this.delegate.notifyWhenStateChanged(source, callback);
        }

        @Override
        public AltsChannel shutdown() {
            this.delegate.shutdown();
            return this;
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public AltsChannel shutdownNow() {
            this.delegate.shutdownNow();
            return this;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            return this.delegate.newCall(methodDescriptor, callOptions);
        }

        @Override
        public String authority() {
            return this.delegate.authority();
        }

        @Override
        public void resetConnectBackoff() {
            this.delegate.resetConnectBackoff();
        }

        @Override
        public void enterIdle() {
            this.delegate.enterIdle();
        }
    }

    private final class TcpfFactory
    implements InternalNettyChannelBuilder.TransportCreationParamsFilterFactory {
        final AltsClientOptions handshakerOptions;
        private final TsiHandshakerFactory altsHandshakerFactory;

        private TcpfFactory() {
            this.handshakerOptions = AltsChannelBuilder.this.handshakerOptionsBuilder.build();
            this.altsHandshakerFactory = new TsiHandshakerFactory(){

                @Override
                public TsiHandshaker newHandshaker() {
                    ManagedChannel channel = HandshakerServiceChannel.get();
                    return AltsTsiHandshaker.newClient(HandshakerServiceGrpc.newStub(channel), TcpfFactory.this.handshakerOptions);
                }
            };
        }

        @Override
        public InternalNettyChannelBuilder.TransportCreationParamsFilter create(final SocketAddress serverAddress, final String authority, final String userAgent, ProxyParameters proxy) {
            Preconditions.checkArgument(serverAddress instanceof InetSocketAddress, "%s must be a InetSocketAddress", (Object)serverAddress);
            final AltsProtocolNegotiator negotiator = AltsProtocolNegotiator.create(this.altsHandshakerFactory);
            return new InternalNettyChannelBuilder.TransportCreationParamsFilter(){

                @Override
                public SocketAddress getTargetServerAddress() {
                    return serverAddress;
                }

                @Override
                public String getAuthority() {
                    return authority;
                }

                @Override
                public String getUserAgent() {
                    return userAgent;
                }

                @Override
                public AltsProtocolNegotiator getProtocolNegotiator() {
                    return negotiator;
                }
            };
        }
    }
}

