/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.common.base.MoreObjects;
import io.grpc.BindableService;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ExperimentalApi;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerStreamTracer;
import io.grpc.ServerTransportFilter;
import io.grpc.alts.CheckGcpEnvironment;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsHandshakerOptions;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.alts.internal.AltsTsiHandshaker;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.RpcProtocolVersionsUtil;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiHandshakerFactory;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsServerBuilder
extends ServerBuilder<AltsServerBuilder> {
    private final NettyServerBuilder delegate;
    private boolean enableUntrustedAlts;

    private AltsServerBuilder(NettyServerBuilder nettyDelegate) {
        this.delegate = nettyDelegate;
    }

    public static AltsServerBuilder forPort(int port) {
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forAddress(new InetSocketAddress(port)).maxConnectionIdle(1L, TimeUnit.HOURS).keepAliveTime(270L, TimeUnit.SECONDS).keepAliveTimeout(20L, TimeUnit.SECONDS).permitKeepAliveTime(10L, TimeUnit.SECONDS).permitKeepAliveWithoutCalls(true);
        return new AltsServerBuilder(nettyDelegate);
    }

    public AltsServerBuilder enableUntrustedAltsForTesting() {
        this.enableUntrustedAlts = true;
        return this;
    }

    public AltsServerBuilder setHandshakerAddressForTesting(String handshakerAddress) {
        HandshakerServiceChannel.setHandshakerAddressForTesting(handshakerAddress);
        return this;
    }

    @Override
    public AltsServerBuilder handshakeTimeout(long timeout, TimeUnit unit) {
        this.delegate.handshakeTimeout(timeout, unit);
        return this;
    }

    @Override
    public AltsServerBuilder directExecutor() {
        this.delegate.directExecutor();
        return this;
    }

    @Override
    public AltsServerBuilder addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.delegate.addStreamTracerFactory(factory);
        return this;
    }

    @Override
    public AltsServerBuilder addTransportFilter(ServerTransportFilter filter) {
        this.delegate.addTransportFilter(filter);
        return this;
    }

    @Override
    public AltsServerBuilder executor(Executor executor) {
        this.delegate.executor(executor);
        return this;
    }

    @Override
    public AltsServerBuilder addService(ServerServiceDefinition service) {
        this.delegate.addService(service);
        return this;
    }

    @Override
    public AltsServerBuilder addService(BindableService bindableService) {
        this.delegate.addService(bindableService);
        return this;
    }

    @Override
    public AltsServerBuilder fallbackHandlerRegistry(HandlerRegistry fallbackRegistry) {
        this.delegate.fallbackHandlerRegistry(fallbackRegistry);
        return this;
    }

    @Override
    public AltsServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("Can't set TLS settings for ALTS");
    }

    @Override
    public AltsServerBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.delegate.decompressorRegistry(registry);
        return this;
    }

    @Override
    public AltsServerBuilder compressorRegistry(CompressorRegistry registry) {
        this.delegate.compressorRegistry(registry);
        return this;
    }

    @Override
    public AltsServerBuilder intercept(ServerInterceptor interceptor) {
        this.delegate.intercept(interceptor);
        return this;
    }

    @Override
    public Server build() {
        CheckGcpEnvironment.check(this.enableUntrustedAlts);
        this.delegate.protocolNegotiator(AltsProtocolNegotiator.create(new TsiHandshakerFactory(){

            @Override
            public TsiHandshaker newHandshaker() {
                return AltsTsiHandshaker.newServer(HandshakerServiceGrpc.newStub(HandshakerServiceChannel.get()), new AltsHandshakerOptions(RpcProtocolVersionsUtil.getRpcProtocolVersions()));
            }
        }));
        return new AltsServer(this.delegate.build());
    }

    static final class AltsServer
    extends Server {
        private final Server delegate;

        AltsServer(Server delegate) {
            this.delegate = delegate;
        }

        @Override
        public List<ServerServiceDefinition> getImmutableServices() {
            return this.delegate.getImmutableServices();
        }

        @Override
        public List<ServerServiceDefinition> getMutableServices() {
            return this.delegate.getMutableServices();
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public List<ServerServiceDefinition> getServices() {
            return this.delegate.getServices();
        }

        @Override
        public Server start() throws IOException {
            this.delegate.start();
            return this;
        }

        @Override
        public Server shutdown() {
            this.delegate.shutdown();
            return this;
        }

        @Override
        public Server shutdownNow() {
            this.delegate.shutdownNow();
            return this;
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public void awaitTermination() throws InterruptedException {
            this.delegate.awaitTermination();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("delegate", this.delegate).toString();
        }
    }
}

