/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.alts.internal.Altscontext;
import io.grpc.alts.internal.Handshaker;
import io.grpc.alts.internal.TransportSecurityCommon;

public final class AltsAuthContext {
    final Altscontext.AltsContext context;

    public AltsAuthContext(Handshaker.HandshakerResult result) {
        this.context = Altscontext.AltsContext.newBuilder().setApplicationProtocol(result.getApplicationProtocol()).setRecordProtocol(result.getRecordProtocol()).setSecurityLevel(TransportSecurityCommon.SecurityLevel.INTEGRITY_AND_PRIVACY).setPeerServiceAccount(result.getPeerIdentity().getServiceAccount()).setLocalServiceAccount(result.getLocalIdentity().getServiceAccount()).setPeerRpcVersions(result.getPeerRpcVersions()).build();
    }

    @VisibleForTesting
    public static AltsAuthContext getDefaultInstance() {
        return new AltsAuthContext(Handshaker.HandshakerResult.newBuilder().build());
    }

    public String getApplicationProtocol() {
        return this.context.getApplicationProtocol();
    }

    public String getRecordProtocol() {
        return this.context.getRecordProtocol();
    }

    public TransportSecurityCommon.SecurityLevel getSecurityLevel() {
        return this.context.getSecurityLevel();
    }

    public String getPeerServiceAccount() {
        return this.context.getPeerServiceAccount();
    }

    public String getLocalServiceAccount() {
        return this.context.getLocalServiceAccount();
    }

    public TransportSecurityCommon.RpcProtocolVersions getPeerRpcVersions() {
        return this.context.getPeerRpcVersions();
    }
}

