/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.alts.internal.ProtectedPromise;
import io.grpc.alts.internal.TsiFrameProtector;
import io.grpc.alts.internal.TsiHandshakeHandler;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelException;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelOutboundHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import io.grpc.netty.shaded.io.netty.channel.PendingWriteQueue;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;

public final class TsiFrameHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private TsiFrameProtector protector;
    private PendingWriteQueue pendingUnprotectedWrites;

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        assert (this.pendingUnprotectedWrites == null);
        this.pendingUnprotectedWrites = new PendingWriteQueue(Preconditions.checkNotNull(ctx));
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        TsiHandshakeHandler.TsiHandshakeCompletionEvent tsiEvent;
        if (event instanceof TsiHandshakeHandler.TsiHandshakeCompletionEvent && (tsiEvent = (TsiHandshakeHandler.TsiHandshakeCompletionEvent)event).isSuccess()) {
            this.setProtector(tsiEvent.protector());
        }
        super.userEventTriggered(ctx, event);
    }

    @VisibleForTesting
    void setProtector(TsiFrameProtector protector) {
        Preconditions.checkState(this.protector == null);
        this.protector = Preconditions.checkNotNull(protector);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Preconditions.checkState(this.protector != null, "Cannot read frames while the TSI handshake is in progress");
        this.protector.unprotect(in, out, ctx.alloc());
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object message, ChannelPromise promise) throws Exception {
        Preconditions.checkState(this.protector != null, "Cannot write frames while the TSI handshake is in progress");
        ByteBuf msg = (ByteBuf)message;
        if (!msg.isReadable()) {
            ChannelPromise possiblyIgnoredError = promise.setSuccess();
            return;
        }
        this.pendingUnprotectedWrites.add(msg, promise);
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        if (!this.pendingUnprotectedWrites.isEmpty()) {
            this.pendingUnprotectedWrites.removeAndFailAll(new ChannelException("Pending write on removal of TSI handler"));
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.pendingUnprotectedWrites.removeAndFailAll(cause);
        super.exceptionCaught(ctx, cause);
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
        ctx.bind(localAddress, promise);
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) {
        ctx.read();
    }

    @Override
    public void flush(final ChannelHandlerContext ctx) throws GeneralSecurityException {
        Preconditions.checkState(this.protector != null, "Cannot write frames while the TSI handshake is in progress");
        final ProtectedPromise aggregatePromise = new ProtectedPromise(ctx.channel(), ctx.executor(), this.pendingUnprotectedWrites.size());
        ArrayList<ByteBuf> bufs = new ArrayList<ByteBuf>(this.pendingUnprotectedWrites.size());
        if (this.pendingUnprotectedWrites.isEmpty()) {
            return;
        }
        while (!this.pendingUnprotectedWrites.isEmpty()) {
            ByteBuf in = (ByteBuf)this.pendingUnprotectedWrites.current();
            bufs.add(in.retain());
            aggregatePromise.addUnprotectedPromise(this.pendingUnprotectedWrites.remove());
        }
        this.protector.protectFlush(bufs, new TsiFrameProtector.Consumer<ByteBuf>(){

            @Override
            public void accept(ByteBuf b) {
                ctx.writeAndFlush(b, aggregatePromise.newPromise());
            }
        }, ctx.alloc());
        ChannelPromise possiblyIgnoredError = aggregatePromise.doneAllocatingPromises();
    }
}

