/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.alts.internal.NettyTsiHandshaker;
import io.grpc.alts.internal.TsiFrameProtector;
import io.grpc.alts.internal.TsiPeer;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import io.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.util.ReferenceCountUtil;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.annotation.Nullable;

public final class TsiHandshakeHandler
extends ByteToMessageDecoder {
    private static final int HANDSHAKE_FRAME_SIZE = 1024;
    private final NettyTsiHandshaker handshaker;
    private boolean started;
    private ByteBuf buffer;

    public TsiHandshakeHandler(NettyTsiHandshaker handshaker) {
        this.handshaker = Preconditions.checkNotNull(handshaker);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.maybeStart(ctx);
        super.handlerAdded(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.maybeStart(ctx);
        super.channelActive(ctx);
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.close();
        super.handlerRemoved0(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireUserEventTriggered(new TsiHandshakeCompletionEvent(cause));
        super.exceptionCaught(ctx, cause);
    }

    @Override
    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        this.decode(ctx, in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.handshaker.processBytesFromPeer(in) && this.handshaker.isInProgress()) {
            this.sendHandshake(ctx);
        }
        if (!this.handshaker.isInProgress()) {
            try {
                ctx.pipeline().remove(this);
                ctx.fireUserEventTriggered(new TsiHandshakeCompletionEvent(this.handshaker.createFrameProtector(ctx.alloc()), this.handshaker.extractPeer(), this.handshaker.extractPeerObject()));
            }
            finally {
                this.close();
            }
        }
    }

    private void maybeStart(ChannelHandlerContext ctx) {
        if (!this.started && ctx.channel().isActive()) {
            this.started = true;
            this.sendHandshake(ctx);
        }
    }

    private void sendHandshake(ChannelHandlerContext ctx) {
        boolean needToFlush = false;
        while (true) {
            this.buffer = this.getOrCreateBuffer(ctx.alloc());
            try {
                this.handshaker.getBytesToSendToPeer(this.buffer);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            if (!this.buffer.isReadable()) break;
            needToFlush = true;
            ChannelFuture possiblyIgnoredError = ctx.write(this.buffer);
            this.buffer = null;
        }
        if (needToFlush) {
            ctx.flush();
        }
    }

    private ByteBuf getOrCreateBuffer(ByteBufAllocator alloc) {
        if (this.buffer == null) {
            this.buffer = alloc.buffer(1024);
        }
        return this.buffer;
    }

    private void close() {
        ReferenceCountUtil.safeRelease(this.buffer);
        this.buffer = null;
    }

    public static final class TsiHandshakeCompletionEvent {
        private final Throwable cause;
        private final TsiPeer peer;
        private final Object context;
        private final TsiFrameProtector protector;

        @VisibleForTesting
        TsiHandshakeCompletionEvent(TsiFrameProtector protector, TsiPeer peer, @Nullable Object peerObject) {
            this.cause = null;
            this.peer = Preconditions.checkNotNull(peer);
            this.protector = Preconditions.checkNotNull(protector);
            this.context = peerObject;
        }

        TsiHandshakeCompletionEvent(Throwable cause) {
            this.cause = Preconditions.checkNotNull(cause);
            this.peer = null;
            this.protector = null;
            this.context = null;
        }

        public boolean isSuccess() {
            return this.cause == null;
        }

        @Nullable
        public Throwable cause() {
            return this.cause;
        }

        @Nullable
        public TsiPeer peer() {
            return this.peer;
        }

        @Nullable
        public Object context() {
            return this.context;
        }

        @Nullable
        TsiFrameProtector protector() {
            return this.protector;
        }
    }
}

