/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.grpclb.SubchannelPool;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

final class CachedSubchannelPool
implements SubchannelPool {
    private final HashMap<EquivalentAddressGroup, CacheEntry> cache = new HashMap();
    private LoadBalancer.Helper helper;
    private ScheduledExecutorService timerService;
    @VisibleForTesting
    static final long SHUTDOWN_TIMEOUT_MS = 10000L;

    CachedSubchannelPool() {
    }

    @Override
    public void init(LoadBalancer.Helper helper, ScheduledExecutorService timerService) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.timerService = Preconditions.checkNotNull(timerService, "timerService");
    }

    @Override
    public LoadBalancer.Subchannel takeOrCreateSubchannel(EquivalentAddressGroup eag, Attributes defaultAttributes) {
        LoadBalancer.Subchannel subchannel;
        CacheEntry entry = this.cache.remove(eag);
        if (entry == null) {
            subchannel = this.helper.createSubchannel(eag, defaultAttributes);
        } else {
            subchannel = entry.subchannel;
            entry.shutdownTimer.cancel(false);
        }
        return subchannel;
    }

    @Override
    public void returnSubchannel(LoadBalancer.Subchannel subchannel) {
        CacheEntry prev = this.cache.get(subchannel.getAddresses());
        if (prev != null) {
            if (prev.subchannel != subchannel) {
                subchannel.shutdown();
            }
            return;
        }
        ShutdownSubchannelTask shutdownTask = new ShutdownSubchannelTask(subchannel);
        ScheduledFuture<?> shutdownTimer = this.timerService.schedule(new ShutdownSubchannelScheduledTask(shutdownTask), 10000L, TimeUnit.MILLISECONDS);
        shutdownTask.timer = shutdownTimer;
        CacheEntry entry = new CacheEntry(subchannel, shutdownTimer);
        this.cache.put(subchannel.getAddresses(), entry);
    }

    @Override
    public void clear() {
        for (CacheEntry entry : this.cache.values()) {
            entry.shutdownTimer.cancel(false);
            entry.subchannel.shutdown();
        }
        this.cache.clear();
    }

    private static class CacheEntry {
        final LoadBalancer.Subchannel subchannel;
        final ScheduledFuture<?> shutdownTimer;

        CacheEntry(LoadBalancer.Subchannel subchannel, ScheduledFuture<?> shutdownTimer) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
            this.shutdownTimer = Preconditions.checkNotNull(shutdownTimer, "shutdownTimer");
        }
    }

    @VisibleForTesting
    final class ShutdownSubchannelTask
    implements Runnable {
        private final LoadBalancer.Subchannel subchannel;
        private ScheduledFuture<?> timer;

        private ShutdownSubchannelTask(LoadBalancer.Subchannel subchannel) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
        }

        @Override
        public void run() {
            if (!this.timer.isCancelled()) {
                CacheEntry entry = (CacheEntry)CachedSubchannelPool.this.cache.remove(this.subchannel.getAddresses());
                Preconditions.checkState(entry.subchannel == this.subchannel, "Inconsistent state");
                this.subchannel.shutdown();
            }
        }
    }

    @VisibleForTesting
    final class ShutdownSubchannelScheduledTask
    implements Runnable {
        private final ShutdownSubchannelTask task;

        ShutdownSubchannelScheduledTask(ShutdownSubchannelTask task) {
            this.task = Preconditions.checkNotNull(task, "task");
        }

        @Override
        public void run() {
            CachedSubchannelPool.this.helper.runSerialized(this.task);
        }
    }
}

