/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.grpclb.GrpclbState;
import io.grpc.grpclb.LbAddressGroup;
import io.grpc.grpclb.SubchannelPool;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.LogId;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.TimeProvider;
import io.grpc.internal.WithLogId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

class GrpclbLoadBalancer
extends LoadBalancer
implements WithLogId {
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final SubchannelPool subchannelPool;
    private final ObjectPool<ScheduledExecutorService> timerServicePool;
    private ScheduledExecutorService timerService;
    @Nullable
    private GrpclbState grpclbState;

    GrpclbLoadBalancer(LoadBalancer.Helper helper, SubchannelPool subchannelPool, ObjectPool<ScheduledExecutorService> timerServicePool, TimeProvider time, BackoffPolicy.Provider backoffPolicyProvider) {
        Preconditions.checkNotNull(helper, "helper");
        this.timerServicePool = Preconditions.checkNotNull(timerServicePool, "timerServicePool");
        this.timerService = Preconditions.checkNotNull(timerServicePool.getObject(), "timerService");
        Preconditions.checkNotNull(time, "time provider");
        Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.subchannelPool = Preconditions.checkNotNull(subchannelPool, "subchannelPool");
        this.subchannelPool.init(helper, this.timerService);
        this.grpclbState = new GrpclbState(helper, subchannelPool, time, this.timerService, backoffPolicyProvider, this.logId);
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    @Override
    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
        this.grpclbState.handleSubchannelState(subchannel, newState);
    }

    @Override
    public void handleResolvedAddressGroups(List<EquivalentAddressGroup> updatedServers, Attributes attributes) {
        ArrayList<LbAddressGroup> newLbAddressGroups = new ArrayList();
        ArrayList<EquivalentAddressGroup> newBackendServers = new ArrayList();
        for (EquivalentAddressGroup server : updatedServers) {
            String lbAddrAuthority = server.getAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY);
            if (lbAddrAuthority != null) {
                newLbAddressGroups.add(new LbAddressGroup(server, lbAddrAuthority));
                continue;
            }
            newBackendServers.add(server);
        }
        newLbAddressGroups = Collections.unmodifiableList(newLbAddressGroups);
        newBackendServers = Collections.unmodifiableList(newBackendServers);
        this.grpclbState.handleAddresses(newLbAddressGroups, newBackendServers);
    }

    private void resetStates() {
        if (this.grpclbState != null) {
            this.grpclbState.shutdown();
            this.grpclbState = null;
        }
    }

    @Override
    public void shutdown() {
        this.resetStates();
        this.timerService = this.timerServicePool.returnObject(this.timerService);
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.grpclbState != null) {
            this.grpclbState.propagateError(error);
        }
    }

    @Nullable
    @VisibleForTesting
    GrpclbState getGrpclbState() {
        return this.grpclbState;
    }
}

