/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.remote.strprotocol.IStringMessage;
import org.testng.remote.strprotocol.MessageHelper;

public class TestResultMessage
implements IStringMessage {
    private static final long serialVersionUID = -4157150777889117479L;
    protected int m_messageType;
    protected String m_suiteName;
    protected String m_testName;
    protected String m_testClassName;
    protected String m_testMethodName;
    protected String m_stackTrace;
    protected long m_startMillis;
    protected long m_endMillis;
    protected String[] m_parameters = new String[0];
    protected String[] m_paramTypes = new String[0];
    private String m_testDescription;
    private int m_invocationCount;
    private int m_currentInvocationCount;
    private String m_instanceName;

    public TestResultMessage(int resultType, String suiteName, String testName, String className, String methodName, String testDescriptor, String instanceName, String[] params, long startMillis, long endMillis, String stackTrace, int invocationCount, int currentInvocationCount) {
        this.init(resultType, suiteName, testName, className, methodName, stackTrace, startMillis, endMillis, this.extractParams(params), this.extractParamTypes(params), testDescriptor, instanceName, invocationCount, currentInvocationCount);
    }

    public TestResultMessage(String suiteName, String testName, ITestResult result) {
        Throwable throwable = result.getThrowable();
        String stackTrace = null;
        if (2 == result.getStatus() || 4 == result.getStatus()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Throwable cause = throwable;
            if (null != cause) {
                cause.printStackTrace(pw);
                stackTrace = sw.getBuffer().toString();
            } else {
                stackTrace = "unknown stack trace";
            }
        } else if (3 == result.getStatus() && throwable != null && SkipException.class.isAssignableFrom(throwable.getClass())) {
            stackTrace = throwable.getMessage();
        } else if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            stackTrace = sw.toString();
        }
        this.init(1000 + result.getStatus(), suiteName, testName, result.getTestClass().getName(), result.getMethod().getMethod().getName(), MessageHelper.replaceUnicodeCharactersWithAscii(stackTrace), result.getStartMillis(), result.getEndMillis(), this.toString(result.getParameters(), result.getMethod().getMethod().getParameterTypes()), this.toString(result.getMethod().getMethod().getParameterTypes()), MessageHelper.replaceUnicodeCharactersWithAscii(result.getName()), MessageHelper.replaceUnicodeCharactersWithAscii(result.getInstanceName()), result.getMethod().getInvocationCount(), result.getMethod().getCurrentInvocationCount());
    }

    public TestResultMessage(ITestContext testCtx, ITestResult result) {
        this(testCtx.getSuite().getName(), testCtx.getCurrentXmlTest().getName(), result);
    }

    private void init(int resultType, String suiteName, String testName, String className, String methodName, String stackTrace, long startMillis, long endMillis, String[] parameters, String[] types, String testDescription, String instanceName, int invocationCount, int currentInvocationCount) {
        this.m_messageType = resultType;
        this.m_suiteName = suiteName;
        this.m_testName = testName;
        this.m_testClassName = className;
        this.m_testMethodName = methodName;
        this.m_stackTrace = stackTrace;
        this.m_startMillis = startMillis;
        this.m_endMillis = endMillis;
        this.m_parameters = parameters;
        this.m_paramTypes = types;
        this.m_testDescription = testDescription;
        this.m_invocationCount = invocationCount;
        this.m_currentInvocationCount = currentInvocationCount;
        this.m_instanceName = instanceName;
    }

    public int getResult() {
        return this.m_messageType;
    }

    @Override
    public String getMessageAsString() {
        StringBuffer buf = new StringBuffer();
        StringBuffer parambuf = new StringBuffer();
        if (null != this.m_parameters && this.m_parameters.length > 0) {
            for (int j = 0; j < this.m_parameters.length; ++j) {
                if (j > 0) {
                    parambuf.append('\u0004');
                }
                parambuf.append(this.m_paramTypes[j] + ":" + this.m_parameters[j]);
            }
        }
        buf.append(this.m_messageType).append('\u0001').append(this.m_suiteName).append('\u0001').append(this.m_testName).append('\u0001').append(this.m_testClassName).append('\u0001').append(this.m_testMethodName).append('\u0001').append(parambuf).append('\u0001').append(this.m_startMillis).append('\u0001').append(this.m_endMillis).append('\u0001').append(MessageHelper.replaceNewLine(this.m_stackTrace)).append('\u0001').append(MessageHelper.replaceNewLine(this.m_testDescription));
        return buf.toString();
    }

    public String getSuiteName() {
        return this.m_suiteName;
    }

    public String getTestClass() {
        return this.m_testClassName;
    }

    public String getMethod() {
        return this.m_testMethodName;
    }

    public String getName() {
        return this.m_testName;
    }

    public String getStackTrace() {
        return this.m_stackTrace;
    }

    public long getEndMillis() {
        return this.m_endMillis;
    }

    public long getStartMillis() {
        return this.m_startMillis;
    }

    public String[] getParameters() {
        return this.m_parameters;
    }

    public String[] getParameterTypes() {
        return this.m_paramTypes;
    }

    public String getTestDescription() {
        return this.m_testDescription;
    }

    public String toDisplayString() {
        StringBuffer buf = new StringBuffer(this.m_testName != null ? this.m_testName : this.m_testMethodName);
        if (null != this.m_parameters && this.m_parameters.length > 0) {
            buf.append("(");
            for (int i = 0; i < this.m_parameters.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if ("java.lang.String".equals(this.m_paramTypes[i]) && !"null".equals(this.m_parameters[i]) && !"\"\"".equals(this.m_parameters[i])) {
                    buf.append("\"").append(this.m_parameters[i]).append("\"");
                    continue;
                }
                buf.append(this.m_parameters[i]);
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestResultMessage that = (TestResultMessage)o;
        if (this.m_suiteName != null ? !this.m_suiteName.equals(that.m_suiteName) : that.m_suiteName != null) {
            return false;
        }
        if (this.m_testName != null ? !this.m_testName.equals(that.m_testName) : that.m_testName != null) {
            return false;
        }
        if (this.m_testClassName != null ? !this.m_testClassName.equals(that.m_testClassName) : that.m_testClassName != null) {
            return false;
        }
        String toDisplayString = this.toDisplayString();
        return !(toDisplayString != null ? !toDisplayString.equals(that.toDisplayString()) : that.toDisplayString() != null);
    }

    public int hashCode() {
        int result = this.m_suiteName != null ? this.m_suiteName.hashCode() : 0;
        result = 29 * result + (this.m_testName != null ? this.m_testName.hashCode() : 0);
        result = 29 * result + this.m_testClassName.hashCode();
        result = 29 * result + this.toDisplayString().hashCode();
        return result;
    }

    String[] toString(Object[] objects, Class<?>[] objectClasses) {
        if (null == objects) {
            return new String[0];
        }
        List result = Lists.newArrayList(objects.length);
        for (Object o : objects) {
            if (null == o) {
                result.add("null");
                continue;
            }
            if (o.getClass().isArray()) {
                String[] strArray = o.getClass().getComponentType().isPrimitive() ? this.primitiveArrayToString(o) : this.toString((Object[])o, null);
                StringBuilder sb = new StringBuilder("[");
                for (int i = 0; i < strArray.length; ++i) {
                    sb.append(strArray[i]);
                    if (i + 1 >= strArray.length) continue;
                    sb.append(",");
                }
                sb.append("]");
                result.add(sb.toString());
                continue;
            }
            String tostring = o.toString();
            if (Utils.isStringEmpty(tostring)) {
                result.add("\"\"");
                continue;
            }
            result.add(MessageHelper.replaceNewLine(tostring));
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] primitiveArrayToString(Object o) {
        List results;
        block9: {
            long[] array;
            block15: {
                int[] array2;
                block14: {
                    short[] array3;
                    block13: {
                        float[] array4;
                        block12: {
                            double[] array5;
                            block11: {
                                char[] array6;
                                block10: {
                                    boolean[] array7;
                                    block8: {
                                        byte[] array8;
                                        results = Lists.newArrayList();
                                        if (!(o instanceof byte[])) break block8;
                                        for (byte anArray : array8 = (byte[])o) {
                                            results.add(String.valueOf(anArray));
                                        }
                                        break block9;
                                    }
                                    if (!(o instanceof boolean[])) break block10;
                                    for (boolean anArray : array7 = (boolean[])o) {
                                        results.add(String.valueOf(anArray));
                                    }
                                    break block9;
                                }
                                if (!(o instanceof char[])) break block11;
                                for (char anArray : array6 = (char[])o) {
                                    results.add(String.valueOf(anArray));
                                }
                                break block9;
                            }
                            if (!(o instanceof double[])) break block12;
                            for (double anArray : array5 = (double[])o) {
                                results.add(String.valueOf(anArray));
                            }
                            break block9;
                        }
                        if (!(o instanceof float[])) break block13;
                        for (float anArray : array4 = (float[])o) {
                            results.add(String.valueOf(anArray));
                        }
                        break block9;
                    }
                    if (!(o instanceof short[])) break block14;
                    for (short anArray : array3 = (short[])o) {
                        results.add(String.valueOf(anArray));
                    }
                    break block9;
                }
                if (!(o instanceof int[])) break block15;
                for (int anArray : array2 = (int[])o) {
                    results.add(String.valueOf(anArray));
                }
                break block9;
            }
            if (!(o instanceof long[])) break block9;
            for (long anArray : array = (long[])o) {
                results.add(String.valueOf(anArray));
            }
        }
        return results.toArray(new String[results.size()]);
    }

    private String[] toString(Class<?>[] classes) {
        if (null == classes) {
            return new String[0];
        }
        List result = Lists.newArrayList(classes.length);
        for (Class<?> cls : classes) {
            result.add(cls.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] extractParamTypes(String[] params) {
        List result = Lists.newArrayList(params.length);
        for (String s2 : params) {
            result.add(s2.substring(0, s2.indexOf(58)));
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] extractParams(String[] params) {
        List result = Lists.newArrayList(params.length);
        for (String s2 : params) {
            result.add(MessageHelper.replaceNewLineReplacer(s2.substring(s2.indexOf(58) + 1)));
        }
        return result.toArray(new String[result.size()]);
    }

    public int getInvocationCount() {
        return this.m_invocationCount;
    }

    public int getCurrentInvocationCount() {
        return this.m_currentInvocationCount;
    }

    public String toString() {
        return "[TestResultMessage suite:" + this.m_suiteName + " test:" + this.m_testName + " method:" + this.m_testMethodName + "]";
    }

    public void setParameters(String[] params) {
        this.m_parameters = this.extractParams(params);
        this.m_paramTypes = this.extractParamTypes(params);
    }

    public String getInstanceName() {
        return this.m_instanceName;
    }
}

