/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.extensions.api.handler;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.rest.AbstractHandler;

public class CellerySignedJWTInjectionHandler
extends AbstractHandler {
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final String JWT_ASSERTION_HEADER = "X-JWT-Assertion";
    private Log log = LogFactory.getLog(CellerySignedJWTInjectionHandler.class);

    public boolean handleRequest(MessageContext messageContext) {
        String celleryJWT = this.getCelleryJWT(messageContext);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("JWT issued from Cellery STS: " + celleryJWT));
        }
        this.removeCellerySTSHeader(messageContext);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Removed JWT Assertion Header: X-JWT-Assertion");
        }
        String bearerHeader = "Bearer " + celleryJWT;
        this.setAuthorizationHeader(messageContext, bearerHeader);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Set new Authorization Header Value to: " + bearerHeader));
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        return true;
    }

    private String getCelleryJWT(MessageContext messageContext) {
        return (String)this.getTransportHeaders(messageContext).get(JWT_ASSERTION_HEADER);
    }

    private void setAuthorizationHeader(MessageContext messageContext, String value) {
        this.getTransportHeaders(messageContext).put(AUTHORIZATION_HEADER_NAME, value);
    }

    private void removeCellerySTSHeader(MessageContext messageContext) {
        this.getTransportHeaders(messageContext).remove(JWT_ASSERTION_HEADER);
    }

    private Map getTransportHeaders(MessageContext messageContext) {
        return (Map)((Axis2MessageContext)messageContext).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
    }
}

