/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.extensions.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.cellery.security.extensions.exception.CelleryAuthException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class CellerySignedJWTBuilder {
    private static final String TENANT_DOMAIN = "carbon.super";
    private static final int TENANT_ID = -1234;
    private static final String MICRO_GATEWAY_DEFAULT_AUDIENCE_VALUE = "http://io.cellery.apimgt/gateway";
    private static final String CELLERY_STS_ISSUER_CONFIG = "Cellery.STS.Issuer";
    private static final String DEFAULT_ISSUER_VALUE = "https://sts.cellery.io";
    private static final String SCOPE_CLAIM = "scope";
    private static final String KEY_TYPE_CLAIM = "keytype";
    private static final String PRODUCTION_KEY_TYPE = "PRODUCTION";
    private JWSHeader.Builder headerBuilder = new JWSHeader.Builder(JWSAlgorithm.RS256);
    private JWTClaimsSet.Builder claimSetBuilder = new JWTClaimsSet.Builder();
    private long expiryInSeconds = 1200L;
    private List<String> audience = new ArrayList<String>();

    public CellerySignedJWTBuilder subject(String subject) {
        this.claimSetBuilder.subject(subject);
        return this;
    }

    public CellerySignedJWTBuilder claim(String name, Object value) {
        this.claimSetBuilder.claim(name, value);
        return this;
    }

    public CellerySignedJWTBuilder claims(Map<String, Object> customClaims) {
        customClaims.forEach((x, y) -> this.claimSetBuilder.claim(x, y));
        return this;
    }

    public CellerySignedJWTBuilder scopes(List<String> scopes) {
        return this.claim(SCOPE_CLAIM, scopes);
    }

    public CellerySignedJWTBuilder expiryInSeconds(long expiryInSeconds) {
        this.expiryInSeconds = expiryInSeconds;
        return this;
    }

    public CellerySignedJWTBuilder audience(List<String> audience) {
        this.audience = audience;
        return this;
    }

    public CellerySignedJWTBuilder audience(String audience) {
        this.audience.add(audience);
        return this;
    }

    private JWSHeader buildJWSHeader() throws IdentityOAuth2Exception {
        String certThumbPrint = OAuth2Util.getThumbPrint((String)TENANT_DOMAIN, (int)-1234);
        this.headerBuilder.keyID(certThumbPrint);
        this.headerBuilder.x509CertThumbprint(new Base64URL(certThumbPrint));
        return this.headerBuilder.build();
    }

    public String build() throws CelleryAuthException {
        try {
            JWSHeader jwsHeader = this.buildJWSHeader();
            this.addMandatoryClaims(this.claimSetBuilder);
            JWTClaimsSet claimsSet = this.claimSetBuilder.build();
            SignedJWT signedJWT = new SignedJWT(jwsHeader, claimsSet);
            RSASSASigner signer = new RSASSASigner((PrivateKey)this.getRSASigningKey());
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (JOSEException | IdentityOAuth2Exception e) {
            throw new CelleryAuthException("Error while generating the signed JWT.", e);
        }
    }

    private void addMandatoryClaims(JWTClaimsSet.Builder claimsSet) {
        Date issuedAt = new Date(System.currentTimeMillis());
        Date expiryTime = new Date(issuedAt.getTime() + this.expiryInSeconds * 1000L);
        List<String> audience = this.getAudience(this.audience);
        claimsSet.jwtID(UUID.randomUUID().toString()).issuer(this.getIssuer()).issueTime(issuedAt).expirationTime(expiryTime).audience(audience).claim(KEY_TYPE_CLAIM, (Object)PRODUCTION_KEY_TYPE);
    }

    private String getIssuer() {
        String issuer = IdentityUtil.getProperty((String)CELLERY_STS_ISSUER_CONFIG);
        if (StringUtils.isEmpty((String)issuer)) {
            issuer = DEFAULT_ISSUER_VALUE;
        }
        return issuer;
    }

    private RSAPrivateKey getRSASigningKey() throws IdentityOAuth2Exception {
        Key privateKey = OAuth2Util.getPrivateKey((String)TENANT_DOMAIN, (int)-1234);
        return (RSAPrivateKey)privateKey;
    }

    private List<String> getAudience(List<String> audience) {
        if (CollectionUtils.isEmpty(audience)) {
            return Collections.singletonList(MICRO_GATEWAY_DEFAULT_AUDIENCE_VALUE);
        }
        return audience.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }
}

