/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.extensions.jwt;

import com.nimbusds.jwt.SignedJWT;
import edu.emory.mathcs.backport.java.util.Arrays;
import io.cellery.security.extensions.exception.CelleryAuthException;
import io.cellery.security.extensions.jwt.CellerySignedJWTBuilder;
import io.cellery.security.extensions.util.Utils;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.impl.APIManagerFactory;
import org.wso2.carbon.apimgt.keymgt.service.TokenValidationContext;
import org.wso2.carbon.apimgt.keymgt.token.JWTGenerator;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CellerySignedJWTGenerator
extends JWTGenerator {
    private static final Log log = LogFactory.getLog(CellerySignedJWTGenerator.class);
    private static final String CONSUMER_KEY_CLAIM = "consumerKey";
    private static final String CELL_NAME = "cell_name";

    public String generateToken(TokenValidationContext validationContext) throws APIManagementException {
        CellerySignedJWTBuilder jwtBuilder = new CellerySignedJWTBuilder();
        try {
            return jwtBuilder.subject(this.getEndUserName(validationContext)).scopes(this.getScopes(validationContext)).claim(CONSUMER_KEY_CLAIM, this.getConsumerKey(validationContext)).claims(this.getClaimsFromSignedJWT(validationContext)).audience(this.getDestinationCell(validationContext)).build();
        }
        catch (CelleryAuthException e) {
            throw new APIManagementException("Error generating JWT for context: " + validationContext, (Throwable)e);
        }
    }

    private String getEndUserName(TokenValidationContext validationContext) throws APIManagementException {
        try {
            String accessToken = validationContext.getAccessToken();
            AccessTokenDO tokenInfo = OAuth2Util.getAccessTokenDOfromTokenIdentifier((String)accessToken);
            AuthenticatedUser authzUser = tokenInfo.getAuthzUser();
            String endUserName = validationContext.getValidationInfoDTO().getEndUserName();
            if (authzUser.isFederatedUser()) {
                return endUserName;
            }
            return MultitenantUtils.getTenantAwareUsername((String)endUserName);
        }
        catch (IdentityOAuth2Exception e) {
            throw new APIManagementException("Error while retrieving authenticated user metadata.", (Throwable)e);
        }
    }

    private String getConsumerKey(TokenValidationContext validationContext) {
        return validationContext.getTokenInfo().getConsumerKey();
    }

    private List<String> getScopes(TokenValidationContext validationContext) {
        Object[] scopes = validationContext.getTokenInfo().getScopes();
        return scopes != null ? Arrays.asList((Object[])scopes) : Collections.emptyList();
    }

    private Map<String, Object> getClaimsFromSignedJWT(TokenValidationContext validationContext) {
        String accessToken = validationContext.getAccessToken();
        if (Utils.isSignedJWT(accessToken)) {
            try {
                SignedJWT signedJWT = SignedJWT.parse((String)accessToken);
                return Utils.getCustomClaims(signedJWT);
            }
            catch (ParseException e) {
                log.error((Object)"Error retrieving claims from the JWT Token.", (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    private String getDestinationCell(TokenValidationContext validationContext) throws APIManagementException {
        String providerName = validationContext.getValidationInfoDTO().getApiPublisher();
        String apiName = validationContext.getValidationInfoDTO().getApiName();
        String apiVersion = this.removeDefaultVersion(validationContext);
        APIIdentifier apiIdentifier = new APIIdentifier(providerName, apiName, apiVersion);
        APIProvider apiProvider = APIManagerFactory.getInstance().getAPIProvider(providerName);
        API api = apiProvider.getAPI(apiIdentifier);
        Object cellName = api.getAdditionalProperties().get((Object)CELL_NAME);
        if (cellName instanceof String) {
            String destinationCell = String.valueOf(cellName);
            log.debug((Object)("Destination Cell for API call is '" + destinationCell + "'"));
            return destinationCell;
        }
        log.debug((Object)"Property:cell_name was not found for the API. This API call is going to an API not published by a Cellery Cell.");
        return null;
    }

    private String removeDefaultVersion(TokenValidationContext validationContext) {
        return validationContext.getVersion().replace("_default_", "");
    }
}

