/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.extensions.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.cellery.security.extensions.util.Utils;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.OAuth2JWTTokenValidator;
import org.wso2.carbon.identity.oauth2.validators.OAuth2TokenValidationMessageContext;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class CellerySignedJWTValidator
extends OAuth2JWTTokenValidator {
    private static final Log log = LogFactory.getLog(CellerySignedJWTValidator.class);
    private static final String CONSUMER_KEY = "consumerKey";

    public boolean validateAccessToken(OAuth2TokenValidationMessageContext validationContext) throws IdentityOAuth2Exception {
        String accessToken = this.getAccessTokenIdentifier(validationContext);
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)accessToken);
            boolean signedJWTValid = this.isSignedJWTValid(signedJWT);
            if (signedJWTValid) {
                JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
                validationContext.addProperty((Object)"REMOTE_ACCESS_TOKEN", (Object)Boolean.TRUE);
                validationContext.addProperty((Object)"JWT_ACCESS_TOKEN", (Object)Boolean.TRUE);
                validationContext.addProperty((Object)"iat", (Object)String.valueOf(this.getTimeInSeconds(claimsSet.getIssueTime())));
                validationContext.addProperty((Object)"exp", (Object)String.valueOf(this.getTimeInSeconds(claimsSet.getExpirationTime())));
                validationContext.addProperty((Object)"client_id", claimsSet.getClaim(CONSUMER_KEY));
                validationContext.addProperty((Object)"sub", (Object)claimsSet.getSubject());
                validationContext.addProperty((Object)"scope", claimsSet.getClaim("scope"));
                validationContext.addProperty((Object)"iss", (Object)claimsSet.getIssuer());
                validationContext.addProperty((Object)"jti", (Object)claimsSet.getJWTID());
            }
            return signedJWTValid;
        }
        catch (ParseException e) {
            throw new IdentityOAuth2Exception("Error validating signed jwt.", (Throwable)e);
        }
    }

    private long getTimeInSeconds(Date date) {
        return date.getTime() / 1000L;
    }

    public boolean validateScope(OAuth2TokenValidationMessageContext messageContext) throws IdentityOAuth2Exception {
        if (Utils.isSignedJWT(this.getAccessTokenIdentifier(messageContext))) {
            return true;
        }
        return super.validateScope(messageContext);
    }

    private String getAccessTokenIdentifier(OAuth2TokenValidationMessageContext messageContext) {
        return messageContext.getRequestDTO().getAccessToken().getIdentifier();
    }

    private boolean isSignedJWTValid(SignedJWT signedJWT) throws IdentityOAuth2Exception {
        try {
            JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
            if (claimsSet == null) {
                throw new IdentityOAuth2Exception("Claim values are empty in the validated JWT.");
            }
            this.validateMandatoryJWTClaims(claimsSet);
            this.validateConsumerKey(claimsSet);
            this.validateExpiryTime(claimsSet);
            this.validateNotBeforeTime(claimsSet);
            this.validateAudience(claimsSet);
            IdentityProvider trustedIdp = this.getTrustedIdp(claimsSet);
            return Utils.validateSignature(signedJWT, trustedIdp);
        }
        catch (ParseException ex) {
            throw new IdentityOAuth2Exception("Error while validating JWT.", (Throwable)ex);
        }
    }

    private void validateConsumerKey(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
        String consumerKey = (String)claimsSet.getClaim(CONSUMER_KEY);
        if (StringUtils.isNotBlank((String)consumerKey)) {
            try {
                OAuth2Util.getAppInformationByClientId((String)consumerKey);
            }
            catch (InvalidOAuthClientException | IdentityOAuth2Exception e) {
                throw new IdentityOAuth2Exception("Invalid consumerKey. Cannot find a registered app for consumerKey: " + consumerKey);
            }
        } else {
            throw new IdentityOAuth2Exception("Mandatory claim 'consumerKey' is missing in the signedJWT.");
        }
    }

    private void validateAudience(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
    }

    private void validateMandatoryJWTClaims(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
        String subject = claimsSet.getSubject();
        List audience = claimsSet.getAudience();
        String jti = claimsSet.getJWTID();
        if (StringUtils.isEmpty((String)claimsSet.getIssuer()) || StringUtils.isEmpty((String)subject) || claimsSet.getExpirationTime() == null || audience == null || jti == null) {
            throw new IdentityOAuth2Exception("Mandatory fields(Issuer, Subject, Expiration time, jtl or Audience) are empty in the given Token.");
        }
    }

    private void validateExpiryTime(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
        long timeStampSkewMillis = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
        long expirationTimeInMillis = claimsSet.getExpirationTime().getTime();
        long currentTimeInMillis = System.currentTimeMillis();
        if (currentTimeInMillis + timeStampSkewMillis > expirationTimeInMillis) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token is expired., Expiration Time(ms) : " + expirationTimeInMillis + ", TimeStamp Skew : " + timeStampSkewMillis + ", Current Time : " + currentTimeInMillis + ". Token Rejected and validation terminated."));
            }
            throw new IdentityOAuth2Exception("Token is expired.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Expiration Time(exp) of Token was validated successfully.");
        }
    }

    private void validateNotBeforeTime(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
        Date notBeforeTime = claimsSet.getNotBeforeTime();
        if (notBeforeTime != null) {
            long timeStampSkewMillis = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
            long notBeforeTimeMillis = notBeforeTime.getTime();
            long currentTimeInMillis = System.currentTimeMillis();
            if (currentTimeInMillis + timeStampSkewMillis < notBeforeTimeMillis) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Token is used before Not_Before_Time., Not Before Time(ms) : " + notBeforeTimeMillis + ", TimeStamp Skew : " + timeStampSkewMillis + ", Current Time : " + currentTimeInMillis + ". Token Rejected and validation terminated."));
                }
                throw new IdentityOAuth2Exception("Token is used before Not_Before_Time.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Not Before Time(nbf) of Token was validated successfully.");
            }
        }
    }

    private IdentityProvider getTrustedIdp(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
        String jwtIssuer = claimsSet.getIssuer();
        String tenantDomain = this.getTenantDomain(claimsSet);
        try {
            IdentityProvider identityProvider = IdentityProviderManager.getInstance().getIdPByName(jwtIssuer, tenantDomain);
            if (identityProvider != null && StringUtils.equalsIgnoreCase((String)identityProvider.getIdentityProviderName(), (String)"default")) {
                identityProvider = this.getLocalIdpForIssuer(jwtIssuer, tenantDomain);
            }
            if (identityProvider == null) {
                throw new IdentityOAuth2Exception("No trusted IDP registered with the issuer: " + jwtIssuer + " in tenantDomain: " + tenantDomain);
            }
            return identityProvider;
        }
        catch (IdentityProviderManagementException e) {
            throw new IdentityOAuth2Exception("Error while retrieving trusted IDP information for issuer: " + jwtIssuer + " in tenantDomain: " + tenantDomain);
        }
    }

    private IdentityProvider getLocalIdpForIssuer(String jwtIssuer, String tenantDomain) throws IdentityOAuth2Exception {
        IdentityProvider residentIdentityProvider;
        String residentIdpIssuer = null;
        try {
            residentIdentityProvider = IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            throw new IdentityOAuth2Exception("Error retrieving resident IDP information for issuer: " + jwtIssuer + " of tenantDomain: " + tenantDomain, (Throwable)e);
        }
        FederatedAuthenticatorConfig[] fedAuthnConfigs = residentIdentityProvider.getFederatedAuthenticatorConfigs();
        FederatedAuthenticatorConfig oauthAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)"openidconnect");
        if (oauthAuthenticatorConfig != null) {
            residentIdpIssuer = IdentityApplicationManagementUtil.getProperty((Property[])oauthAuthenticatorConfig.getProperties(), (String)"IdPEntityId").getValue();
        }
        return StringUtils.equalsIgnoreCase(residentIdpIssuer, (String)jwtIssuer) ? residentIdentityProvider : null;
    }

    private String getTenantDomain(JWTClaimsSet jwtClaimsSet) {
        return "carbon.super";
    }
}

