/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.extensions.km;

import io.cellery.security.extensions.util.Utils;
import java.util.Arrays;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.AccessTokenInfo;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.impl.AMDefaultKeyManagerImpl;
import org.wso2.carbon.identity.oauth2.OAuth2TokenValidationService;
import org.wso2.carbon.identity.oauth2.dto.OAuth2IntrospectionResponseDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class CelleryExtendedKeyManagerImpl
extends AMDefaultKeyManagerImpl {
    private static final String JWT_TOKEN_TYPE = "jwt";

    public AccessTokenInfo getTokenMetaData(String accessToken) throws APIManagementException {
        if (!Utils.isSignedJWT(accessToken)) {
            return super.getTokenMetaData(accessToken);
        }
        OAuth2TokenValidationRequestDTO tokenValidationRequest = this.buildTokenValidationRequest(accessToken);
        OAuth2IntrospectionResponseDTO introspectionResponse = this.introspectToken(tokenValidationRequest);
        AccessTokenInfo tokenInfo = new AccessTokenInfo();
        if (this.isTokenInvalid(introspectionResponse)) {
            tokenInfo.setTokenValid(false);
            tokenInfo.setErrorcode(900901);
        } else {
            tokenInfo.setTokenValid(true);
            tokenInfo.setEndUserName(introspectionResponse.getSub());
            tokenInfo.setConsumerKey(introspectionResponse.getClientId());
            tokenInfo.setIssuedTime(System.currentTimeMillis());
            tokenInfo.setScope(this.buildScopes(introspectionResponse));
            tokenInfo.setValidityPeriod(this.getExpiryPeriodInMillis(introspectionResponse));
            this.handleScopes(introspectionResponse, tokenInfo);
        }
        return tokenInfo;
    }

    private String[] buildScopes(OAuth2IntrospectionResponseDTO introspectionResponse) {
        return OAuth2Util.buildScopeArray((String)introspectionResponse.getScope());
    }

    private OAuth2IntrospectionResponseDTO introspectToken(OAuth2TokenValidationRequestDTO requestDTO) {
        OAuth2TokenValidationService tokenValidationService = new OAuth2TokenValidationService();
        return tokenValidationService.buildIntrospectionResponse(requestDTO);
    }

    private boolean isTokenInvalid(OAuth2IntrospectionResponseDTO responseDTO) {
        return !responseDTO.isActive();
    }

    private long getExpiryPeriodInMillis(OAuth2IntrospectionResponseDTO introspectionResponse) {
        return introspectionResponse.getExp() * 1000L - System.currentTimeMillis();
    }

    public void loadConfiguration(KeyManagerConfiguration configuration) throws APIManagementException {
        super.loadConfiguration(null);
    }

    private void handleScopes(OAuth2IntrospectionResponseDTO responseDTO, AccessTokenInfo tokenInfo) {
        String[] scopes = OAuth2Util.buildScopeArray((String)responseDTO.getScope());
        String applicationTokenScope = this.getConfigurationElementValue("OAuthConfigurations.ApplicationTokenScope");
        if (scopes != null && applicationTokenScope != null && !applicationTokenScope.isEmpty() && Arrays.asList(scopes).contains(applicationTokenScope)) {
            tokenInfo.setApplicationToken(true);
        }
    }

    private OAuth2TokenValidationRequestDTO buildTokenValidationRequest(String accessToken) {
        OAuth2TokenValidationRequestDTO requestDTO = new OAuth2TokenValidationRequestDTO();
        OAuth2TokenValidationRequestDTO.OAuth2AccessToken token = new OAuth2TokenValidationRequestDTO.OAuth2AccessToken(requestDTO);
        token.setIdentifier(accessToken);
        token.setTokenType(JWT_TOKEN_TYPE);
        requestDTO.setAccessToken(token);
        return requestDTO;
    }
}

