/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.extensions.util;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    public static final String OPENID_IDP_ENTITY_ID = "IdPEntityId";
    private static final Set<String> FILTERED_CLAIMS;

    private Utils() {
    }

    public static IdentityProvider getCelleryIDP() throws IdentityProviderManagementException {
        return IdentityProviderManager.getInstance().getResidentIdP("carbon.super");
    }

    public static boolean isSignedJWT(String jwtToTest) {
        return StringUtils.countMatches((String)jwtToTest, (String)".") == 2;
    }

    public static Map<String, Object> getCustomClaims(SignedJWT signedJWT) throws ParseException {
        return signedJWT.getJWTClaimsSet().getClaims().entrySet().stream().filter(x -> !FILTERED_CLAIMS.contains(x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static boolean validateSignature(SignedJWT signedJWT, IdentityProvider idp) throws IdentityOAuth2Exception {
        try {
            X509Certificate x509Certificate = Utils.getCertToValidateJwt(idp);
            String signatureAlgorithm = signedJWT.getHeader().getAlgorithm().getName();
            Utils.validateSignatureAlgorithm(signatureAlgorithm);
            PublicKey publicKey = x509Certificate.getPublicKey();
            if (!(publicKey instanceof RSAPublicKey)) {
                throw new IdentityOAuth2Exception("Public key is not an RSA public key.");
            }
            RSASSAVerifier verifier = new RSASSAVerifier((RSAPublicKey)publicKey);
            return signedJWT.verify((JWSVerifier)verifier);
        }
        catch (JOSEException | CertificateException e) {
            throw new IdentityOAuth2Exception("Error while validating signature of jwt.", e);
        }
    }

    private static void validateSignatureAlgorithm(String signatureAlgorithm) throws IdentityOAuth2Exception {
        if (StringUtils.isEmpty((String)signatureAlgorithm)) {
            throw new IdentityOAuth2Exception("Algorithm must not be null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Signature Algorithm found in the Token Header: " + signatureAlgorithm));
        }
        if (!StringUtils.startsWithIgnoreCase((String)signatureAlgorithm, (String)"RS")) {
            throw new IdentityOAuth2Exception("Signature validation for algorithm: " + signatureAlgorithm + " is not supported.");
        }
    }

    private static X509Certificate getCertToValidateJwt(IdentityProvider idp) throws IdentityOAuth2Exception, CertificateException {
        X509Certificate x509Certificate = (X509Certificate)IdentityApplicationManagementUtil.decodeCertificate((String)idp.getCertificate());
        if (x509Certificate == null) {
            throw new IdentityOAuth2Exception("Unable to locate certificate for Identity Provider: " + idp.getDisplayName());
        }
        return x509Certificate;
    }

    static {
        HashSet<String> n = new HashSet<String>();
        n.add("iss");
        n.add("aud");
        n.add("exp");
        n.add("nbf");
        n.add("iat");
        n.add("jti");
        n.add("scope");
        n.add("keytype");
        FILTERED_CLAIMS = Collections.unmodifiableSet(n);
    }
}

