/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.sts.endpoint.core;

import com.nimbusds.jwt.SignedJWT;
import io.cellery.security.extensions.exception.CelleryAuthException;
import io.cellery.security.extensions.jwt.CellerySignedJWTBuilder;
import io.cellery.security.extensions.util.Utils;
import io.cellery.security.sts.endpoint.core.CellerySTSException;
import io.cellery.security.sts.endpoint.core.CellerySTSRequest;
import io.cellery.security.sts.endpoint.core.CellerySTSResponse;
import java.text.ParseException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;

public class CellerySecureTokenService {
    public CellerySTSResponse issueJWT(CellerySTSRequest tokenRequest) throws CellerySTSException {
        try {
            String subject = tokenRequest.getSource();
            HashMap claims = new HashMap();
            if (StringUtils.isNotBlank((String)tokenRequest.getUserContextJwt())) {
                SignedJWT userContextJwt = SignedJWT.parse((String)tokenRequest.getUserContextJwt());
                if (this.isUserContextJwtValid(userContextJwt)) {
                    subject = userContextJwt.getJWTClaimsSet().getSubject();
                    claims.putAll(Utils.getCustomClaims((SignedJWT)userContextJwt));
                } else {
                    throw new CellerySTSException("Invalid user context JWT presented to obtain a STS token.");
                }
            }
            String jwt = new CellerySignedJWTBuilder().subject(subject).scopes(tokenRequest.getScopes()).audience(tokenRequest.getAudiences()).claims(claims).build();
            CellerySTSResponse cellerySTSResponse = new CellerySTSResponse();
            cellerySTSResponse.setStsToken(jwt);
            return cellerySTSResponse;
        }
        catch (CelleryAuthException e) {
            throw new CellerySTSException("Error issuing JWT.", e);
        }
        catch (ParseException e) {
            throw new CellerySTSException("Error while parsing the user context JWT", e);
        }
    }

    private boolean isUserContextJwtValid(SignedJWT userContextJwt) throws CelleryAuthException {
        try {
            IdentityProvider idp = Utils.getCelleryIDP();
            return Utils.validateSignature((SignedJWT)userContextJwt, (IdentityProvider)idp);
        }
        catch (IdentityOAuth2Exception | IdentityProviderManagementException e) {
            throw new CelleryAuthException("Error while validating user context jwt", e);
        }
    }
}

