/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents;

import io.cloudevents.CloudEvent;
import io.cloudevents.Extension;
import io.cloudevents.SpecVersion;
import io.cloudevents.impl.DefaultCloudEventImpl;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class CloudEventBuilder<T> {
    private String specversion;
    private String contentType;
    private String type;
    private URI source;
    private String id;
    private ZonedDateTime time;
    private URI schemaURL;
    private T data;
    private final List<Extension> extensions = new ArrayList<Extension>();

    public CloudEventBuilder<T> specVersion(String specVersion) {
        this.specversion = specVersion;
        return this;
    }

    public CloudEventBuilder<T> type(String type) {
        this.type = type;
        return this;
    }

    public CloudEventBuilder<T> source(URI source) {
        this.source = source;
        return this;
    }

    public CloudEventBuilder<T> id(String id) {
        this.id = id;
        return this;
    }

    public CloudEventBuilder<T> time(ZonedDateTime time) {
        this.time = time;
        return this;
    }

    public CloudEventBuilder<T> schemaURL(URI schemaURL) {
        this.schemaURL = schemaURL;
        return this;
    }

    public CloudEventBuilder<T> contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public CloudEventBuilder<T> data(T data) {
        this.data = data;
        return this;
    }

    public CloudEventBuilder<T> extension(Extension extension) {
        this.extensions.add(extension);
        return this;
    }

    public CloudEvent<T> build() {
        if (this.specversion == null) {
            this.specversion = SpecVersion.DEFAULT.toString();
        }
        if (this.type == null || this.source == null || this.id == null) {
            throw new IllegalArgumentException("please provide all required fields");
        }
        return new DefaultCloudEventImpl<T>(this.type, this.specversion, this.source, this.id, this.time, this.schemaURL, this.contentType, this.data, this.extensions);
    }
}

