/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.types;

import io.cloudevents.rw.CloudEventRWException;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public final class Time {
    private Time() {
    }

    public static OffsetDateTime parseTime(String time) throws DateTimeParseException {
        return OffsetDateTime.parse(time);
    }

    public static OffsetDateTime parseTime(String attributeName, String time) throws CloudEventRWException {
        try {
            return Time.parseTime(time);
        }
        catch (DateTimeParseException e) {
            throw CloudEventRWException.newInvalidAttributeValue(attributeName, time, e);
        }
    }

    public static String writeTime(OffsetDateTime time) throws DateTimeException {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(time);
    }

    public static String writeTime(String attributeName, OffsetDateTime time) throws DateTimeException {
        try {
            return Time.writeTime(time);
        }
        catch (DateTimeParseException e) {
            throw CloudEventRWException.newInvalidAttributeValue(attributeName, time, e);
        }
    }
}

