/*
 * Decompiled with CFR 0.152.
 */
package io.craftsman;

import io.craftsman.creator.CreatorFactory;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import org.dozer.CustomConverter;

public class Jdk8CompatibilityConverter
implements CustomConverter {
    private CreatorFactory creatorFactory = new CreatorFactory();

    public Object convert(Object destination, Object source, Class<?> destinationClass, Class<?> sourceClass) {
        if (destinationClass == null || sourceClass == null) {
            return destination;
        }
        if (source == null) {
            destination = null;
        } else if (destinationClass.isAssignableFrom(LocalDate.class) && sourceClass.isAssignableFrom(LocalDate.class)) {
            destination = this.creatorFactory.createLocalDateCreator().create(source);
        } else if (destinationClass.isAssignableFrom(LocalTime.class) && sourceClass.isAssignableFrom(LocalTime.class)) {
            destination = this.creatorFactory.createLocalTimeCreator().create(source);
        } else if (destinationClass.isAssignableFrom(LocalDateTime.class) && sourceClass.isAssignableFrom(LocalDateTime.class)) {
            destination = this.creatorFactory.createLocalDateTimeCreator().create(source);
        } else if (destinationClass.isAssignableFrom(ZoneId.class) && source instanceof ZoneId) {
            destination = this.creatorFactory.createZoneIdCreator().create(source);
        } else if (destinationClass.isAssignableFrom(Duration.class) && sourceClass.isAssignableFrom(Duration.class)) {
            destination = this.creatorFactory.createDurationCreator().create(source);
        } else if (destinationClass.isAssignableFrom(Period.class) && sourceClass.isAssignableFrom(Period.class)) {
            destination = this.creatorFactory.createPeriodCreator().create(source);
        }
        return destination;
    }
}

