/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr.listener;

import io.debezium.connector.mysql.MySqlDefaultValueConverter;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.ddl.parser.mysql.generated.MySqlParserBaseListener;
import io.debezium.relational.ColumnEditor;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultValueParserListener
extends MySqlParserBaseListener {
    private final ColumnEditor columnEditor;
    private final AtomicReference<Boolean> optionalColumn;
    private final MySqlDefaultValueConverter defaultValueConverter;
    private final boolean convertDefault;
    private boolean converted;

    public DefaultValueParserListener(ColumnEditor columnEditor, MySqlValueConverters converters, AtomicReference<Boolean> optionalColumn, boolean convertDefault) {
        this.columnEditor = columnEditor;
        this.defaultValueConverter = new MySqlDefaultValueConverter(converters);
        this.optionalColumn = optionalColumn;
        this.convertDefault = convertDefault;
        this.converted = false;
    }

    public void enterDefaultValue(MySqlParser.DefaultValueContext ctx) {
        String sign = "";
        if (ctx.NULL_LITERAL() != null) {
            return;
        }
        if (ctx.unaryOperator() != null) {
            sign = ctx.unaryOperator().getText();
        }
        if (ctx.constant() != null) {
            if (ctx.constant().stringLiteral() != null) {
                this.columnEditor.defaultValue((Object)(sign + this.unquote(ctx.constant().stringLiteral().getText())));
            } else if (ctx.constant().decimalLiteral() != null) {
                this.columnEditor.defaultValue((Object)(sign + ctx.constant().decimalLiteral().getText()));
            } else if (ctx.constant().BIT_STRING() != null) {
                this.columnEditor.defaultValue((Object)this.unquoteBinary(ctx.constant().BIT_STRING().getText()));
            } else if (ctx.constant().booleanLiteral() != null) {
                this.columnEditor.defaultValue((Object)ctx.constant().booleanLiteral().getText());
            } else if (ctx.constant().REAL_LITERAL() != null) {
                this.columnEditor.defaultValue((Object)ctx.constant().REAL_LITERAL().getText());
            }
        } else if (ctx.currentTimestamp() != null && !ctx.currentTimestamp().isEmpty() && (ctx.currentTimestamp().size() > 1 || ctx.ON() == null && ctx.UPDATE() == null)) {
            MySqlParser.CurrentTimestampContext currentTimestamp = ctx.currentTimestamp(0);
            if (currentTimestamp.CURRENT_TIMESTAMP() != null || currentTimestamp.NOW() != null) {
                this.columnEditor.defaultValue((Object)"1970-01-01 00:00:00");
            } else {
                this.columnEditor.defaultValue((Object)currentTimestamp.getText());
            }
        }
        this.convertDefaultValue(true);
        super.enterDefaultValue(ctx);
    }

    public void convertDefaultValue(boolean skipIfUnknownOptional) {
        if (!(!this.convertDefault || this.converted || this.optionalColumn.get() == null && skipIfUnknownOptional)) {
            this.convertDefaultValueToSchemaType(this.columnEditor);
            this.converted = true;
        }
    }

    private void convertDefaultValueToSchemaType(ColumnEditor columnEditor) {
        if (this.optionalColumn.get() != null) {
            columnEditor.optional(this.optionalColumn.get().booleanValue());
        }
        this.defaultValueConverter.setColumnDefaultValue(columnEditor);
    }

    private String unquote(String stringLiteral) {
        return stringLiteral.substring(1, stringLiteral.length() - 1);
    }

    private String unquoteBinary(String stringLiteral) {
        return stringLiteral.substring(2, stringLiteral.length() - 1);
    }
}

