/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSchemaChangeEventEmitter
implements SchemaChangeEventEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleSchemaChangeEventEmitter.class);
    private final OraclePartition partition;
    private final OracleOffsetContext offsetContext;
    private final TableId tableId;
    private final OracleDatabaseSchema schema;
    private final Instant changeTime;
    private final String sourceDatabaseName;
    private final String objectOwner;
    private final String ddlText;
    private final Tables.TableFilter filters;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;

    public OracleSchemaChangeEventEmitter(OracleConnectorConfig connectorConfig, OraclePartition partition, OracleOffsetContext offsetContext, TableId tableId, String sourceDatabaseName, String objectOwner, String ddlText, OracleDatabaseSchema schema, Instant changeTime, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        this.partition = partition;
        this.offsetContext = offsetContext;
        this.tableId = tableId;
        this.sourceDatabaseName = sourceDatabaseName;
        this.objectOwner = objectOwner;
        this.ddlText = ddlText;
        this.schema = schema;
        this.changeTime = changeTime;
        this.streamingMetrics = streamingMetrics;
        this.filters = connectorConfig.getTableFilters().dataCollectionFilter();
    }

    public void emitSchemaChangeEvent(SchemaChangeEventEmitter.Receiver receiver) throws InterruptedException {
        Table tableBefore = this.schema.tableFor(this.tableId);
        OracleDdlParser parser = this.schema.getDdlParser();
        DdlChanges ddlChanges = parser.getDdlChanges();
        try {
            ddlChanges.reset();
            parser.setCurrentDatabase(this.sourceDatabaseName);
            parser.setCurrentSchema(this.objectOwner);
            parser.parse(this.ddlText, this.schema.getTables());
        }
        catch (MultipleParsingExceptions | ParsingException e) {
            if (this.schema.skipUnparseableDdlStatements()) {
                LOGGER.warn("Ignoring unparsable DDL statement '{}': {}", (Object)this.ddlText, (Object)e);
                this.streamingMetrics.incrementWarningCount();
                this.streamingMetrics.incrementUnparsableDdlCount();
            }
            throw e;
        }
        if (!ddlChanges.isEmpty() && this.filters.isIncluded(this.tableId)) {
            ArrayList changeEvents = new ArrayList();
            ddlChanges.getEventsByDatabase((dbName, events) -> events.forEach(event -> {
                switch (event.type()) {
                    case CREATE_TABLE: {
                        changeEvents.add(this.createTableEvent(this.partition, (DdlParserListener.TableCreatedEvent)event));
                        break;
                    }
                    case ALTER_TABLE: {
                        changeEvents.add(this.alterTableEvent(this.partition, (DdlParserListener.TableAlteredEvent)event));
                        break;
                    }
                    case DROP_TABLE: {
                        changeEvents.add(this.dropTableEvent(this.partition, tableBefore, (DdlParserListener.TableDroppedEvent)event));
                        break;
                    }
                    default: {
                        LOGGER.info("Skipped DDL event type {}: {}", (Object)event.type(), (Object)this.ddlText);
                    }
                }
            }));
            for (SchemaChangeEvent event : changeEvents) {
                receiver.schemaChangeEvent(event);
            }
        }
    }

    private SchemaChangeEvent createTableEvent(OraclePartition partition, DdlParserListener.TableCreatedEvent event) {
        this.offsetContext.tableEvent(this.tableId, this.changeTime);
        return new SchemaChangeEvent(partition.getSourcePartition(), this.offsetContext.getOffset(), this.offsetContext.getSourceInfo(), this.tableId.catalog(), this.tableId.schema(), event.statement(), this.schema.tableFor(event.tableId()), SchemaChangeEvent.SchemaChangeEventType.CREATE, false);
    }

    private SchemaChangeEvent alterTableEvent(OraclePartition partition, DdlParserListener.TableAlteredEvent event) {
        HashSet<TableId> tableIds = new HashSet<TableId>();
        tableIds.add(this.tableId);
        tableIds.add(event.tableId());
        this.offsetContext.tableEvent(tableIds, this.changeTime);
        return new SchemaChangeEvent(partition.getSourcePartition(), this.offsetContext.getOffset(), this.offsetContext.getSourceInfo(), this.tableId.catalog(), this.tableId.schema(), event.statement(), this.schema.tableFor(event.tableId()), SchemaChangeEvent.SchemaChangeEventType.ALTER, false);
    }

    private SchemaChangeEvent dropTableEvent(OraclePartition partition, Table tableSchemaBeforeDrop, DdlParserListener.TableDroppedEvent event) {
        this.offsetContext.tableEvent(this.tableId, this.changeTime);
        return new SchemaChangeEvent(partition.getSourcePartition(), this.offsetContext.getOffset(), this.offsetContext.getSourceInfo(), this.tableId.catalog(), this.tableId.schema(), event.statement(), tableSchemaBeforeDrop, SchemaChangeEvent.SchemaChangeEventType.DROP, false);
    }
}

