/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.util.List;

public class OracleTableIdParser {
    public static TableId parse(String identifier) {
        String[] parts = TableId.parseParts((String)identifier);
        if (parts.length > 3) {
            String tableName = parts[parts.length - 1];
            String schemaName = parts[parts.length - 2];
            String catalogName = OracleTableIdParser.resolveCatalogFromDomainName(parts);
            return new TableId(catalogName, schemaName, tableName);
        }
        return TableId.parse((String)identifier, (boolean)false);
    }

    public static String quoteIfNeeded(TableId tableId, boolean useCatalog, boolean useSchema, List<String> keywords) {
        StringBuilder sb = new StringBuilder();
        if (useCatalog) {
            sb.append(OracleTableIdParser.quotePartIfNeeded(tableId.catalog(), keywords)).append(".");
        } else if (useSchema) {
            sb.append(OracleTableIdParser.quotePartIfNeeded(tableId.schema(), keywords)).append(".");
        }
        return sb.append(OracleTableIdParser.quotePartIfNeeded(tableId.table(), keywords)).toString();
    }

    private static String quotePartIfNeeded(String part, List<String> keywords) {
        if (!Strings.isNullOrEmpty((String)part) && (part.startsWith("_") || keywords.stream().anyMatch(keyword -> keyword.equalsIgnoreCase(part)))) {
            return "\"" + part + "\"";
        }
        return part;
    }

    private static String resolveCatalogFromDomainName(String[] parts) {
        StringBuilder catalogName = new StringBuilder(parts[0]);
        for (int index = 1; index < parts.length - 2; ++index) {
            catalogName.append('.').append(parts[index]);
        }
        return catalogName.toString();
    }
}

