/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.OracleCommonStreamingChangeEventSourceMetricsMXBean;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.pipeline.metrics.DefaultStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public abstract class AbstractOracleStreamingChangeEventSourceMetrics
extends DefaultStreamingChangeEventSourceMetrics<OraclePartition>
implements OracleCommonStreamingChangeEventSourceMetricsMXBean {
    private final AtomicLong schemaChangeParseErrorCount = new AtomicLong();
    private final AtomicLong committedTransactionCount = new AtomicLong();
    private final AtomicLong lastCapturedDmlCount = new AtomicLong();
    private final AtomicLong maxCapturedDmlCount = new AtomicLong();
    private final AtomicLong totalCapturedDmlCount = new AtomicLong();
    private final AtomicLong warningCount = new AtomicLong();
    private final AtomicLong errorCount = new AtomicLong();

    public AbstractOracleStreamingChangeEventSourceMetrics(CdcSourceTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider) {
        super(taskContext, changeEventQueueMetrics, metadataProvider);
    }

    public void reset() {
        super.reset();
        this.committedTransactionCount.set(0L);
        this.lastCapturedDmlCount.set(0L);
        this.maxCapturedDmlCount.set(0L);
        this.totalCapturedDmlCount.set(0L);
        this.warningCount.set(0L);
        this.errorCount.set(0L);
    }

    public long getNumberOfCommittedTransactions() {
        return this.committedTransactionCount.get();
    }

    @Override
    public long getTotalSchemaChangeParseErrorCount() {
        return this.schemaChangeParseErrorCount.get();
    }

    @Override
    public long getLastCapturedDmlCount() {
        return this.lastCapturedDmlCount.get();
    }

    @Override
    public long getMaxCapturedDmlCountInBatch() {
        return this.maxCapturedDmlCount.get();
    }

    @Override
    public long getTotalCapturedDmlCount() {
        return this.totalCapturedDmlCount.get();
    }

    @Override
    public long getWarningCount() {
        return this.warningCount.get();
    }

    @Override
    public long getErrorCount() {
        return this.errorCount.get();
    }

    public void setLastCapturedDmlCount(int lastDmlCount) {
        this.lastCapturedDmlCount.set(lastDmlCount);
        if (this.maxCapturedDmlCount.get() < (long)lastDmlCount) {
            this.maxCapturedDmlCount.set(lastDmlCount);
        }
        this.totalCapturedDmlCount.getAndAdd(lastDmlCount);
    }

    public void incrementSchemaChangeParseErrorCount() {
        this.schemaChangeParseErrorCount.incrementAndGet();
    }

    public void incrementWarningCount() {
        this.warningCount.incrementAndGet();
    }

    public void incrementErrorCount() {
        this.errorCount.incrementAndGet();
    }

    public void incrementCommittedTransactionCount() {
        this.committedTransactionCount.incrementAndGet();
    }
}

