package io.dekorate.kubernetes.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AnnotationFluent<A extends AnnotationFluent<A>> extends BaseFluent<A>{
  public AnnotationFluent() {
  }
  
  public AnnotationFluent(Annotation instance) {
    this.copyInstance(instance);
  }
  private String key;
  private String value;
  private List<String> kinds = new ArrayList<String>();
  
  protected void copyInstance(Annotation instance) {
    instance = (instance != null ? instance : new Annotation());
    if (instance != null) {
          this.withKey(instance.getKey());
          this.withValue(instance.getValue());
          this.withKinds(instance.getKinds());
        }
  }
  
  public String getKey() {
    return this.key;
  }
  
  public A withKey(String key) {
    this.key = key;
    return (A) this;
  }
  
  public boolean hasKey() {
    return this.key != null;
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value = value;
    return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public A withKinds(java.lang.String... kinds) {
    if (this.kinds != null) {
        this.kinds.clear();
        _visitables.remove("kinds");
    }
    if (kinds != null) {
      for (String item : kinds) {
        this.addToKinds(item);
      }
    }
    return (A) this;
  }
  
  public String[] getKinds() {
    int size = kinds != null ? kinds.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : kinds) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToKinds(int index,String item) {
    if (this.kinds == null) {this.kinds = new ArrayList<String>();}
    this.kinds.add(index, item);
    return (A)this;
  }
  
  public A setToKinds(int index,String item) {
    if (this.kinds == null) {this.kinds = new ArrayList<String>();}
    this.kinds.set(index, item); return (A)this;
  }
  
  public A addToKinds(java.lang.String... items) {
    if (this.kinds == null) {this.kinds = new ArrayList<String>();}
    for (String item : items) {this.kinds.add(item);} return (A)this;
  }
  
  public A addAllToKinds(Collection<String> items) {
    if (this.kinds == null) {this.kinds = new ArrayList<String>();}
    for (String item : items) {this.kinds.add(item);} return (A)this;
  }
  
  public A removeFromKinds(java.lang.String... items) {
    if (this.kinds == null) return (A)this;
    for (String item : items) { this.kinds.remove(item);} return (A)this;
  }
  
  public A removeAllFromKinds(Collection<String> items) {
    if (this.kinds == null) return (A)this;
    for (String item : items) { this.kinds.remove(item);} return (A)this;
  }
  
  public boolean hasKinds() {
    return this.kinds != null && !this.kinds.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AnnotationFluent that = (AnnotationFluent) o;
    if (!java.util.Objects.equals(key, that.key)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(kinds, that.kinds)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(key,  value,  kinds,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (key != null) { sb.append("key:"); sb.append(key + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (kinds != null && !kinds.isEmpty()) { sb.append("kinds:"); sb.append(kinds); }
    sb.append("}");
    return sb.toString();
  }
  

}