package io.dekorate.kubernetes.config;

import java.lang.SuppressWarnings;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ApplicationConfigurationFluent<A extends ApplicationConfigurationFluent<A>> extends ConfigurationFluent<A>{
  public ApplicationConfigurationFluent() {
  }
  
  public ApplicationConfigurationFluent(ApplicationConfiguration instance) {
    this.copyInstance(instance);
  }
  private String partOf;
  private String name;
  private String version;
  
  protected void copyInstance(ApplicationConfiguration instance) {
    instance = (instance != null ? instance : new ApplicationConfiguration());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withPartOf(instance.getPartOf());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
        }
  }
  
  public String getPartOf() {
    return this.partOf;
  }
  
  public A withPartOf(String partOf) {
    this.partOf = partOf;
    return (A) this;
  }
  
  public boolean hasPartOf() {
    return this.partOf != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ApplicationConfigurationFluent that = (ApplicationConfigurationFluent) o;
    if (!java.util.Objects.equals(partOf, that.partOf)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(partOf,  name,  version,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (partOf != null) { sb.append("partOf:"); sb.append(partOf + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  

}