package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class AwsElasticBlockStoreVolume{
  public AwsElasticBlockStoreVolume() {
  }
  
  public AwsElasticBlockStoreVolume(String volumeName,String volumeId,Integer partition,String fsType,Boolean readOnly) {
    this.volumeName = volumeName;
    this.volumeId = volumeId;
    this.partition = partition;
    this.fsType = fsType;
    this.readOnly = readOnly;
  }
  private String volumeName;
  private String volumeId;
  private Integer partition;
  private String fsType;
  private Boolean readOnly;
  
  
  /**
   * The volumeName name.
   * @return The volumeName name.
   */
  public String getVolumeName() {
    return this.volumeName;
  }
  
  
  /**
   * The name of the disk to mount.
   * @return The name.
   */
  public String getVolumeId() {
    return this.volumeId;
  }
  
  public Integer getPartition() {
    return this.partition;
  }
  
  public String getFsType() {
    return this.fsType;
  }
  
  
  /**
   * Wether the volumeName is read only or not.
   * @return True if read only, False otherwise.
   */
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  
  /**
   * Wether the volumeName is read only or not.
   * @return True if read only, False otherwise.
   */
  public boolean isReadOnly() {
    return this.readOnly != null &&  this.readOnly;
  }
  
  public static AwsElasticBlockStoreVolumeBuilder newBuilder() {
    return new AwsElasticBlockStoreVolumeBuilder();
  }
  
  public static AwsElasticBlockStoreVolumeBuilder newBuilderFromDefaults() {
    return new AwsElasticBlockStoreVolumeBuilder().withFsType("ext4").withReadOnly(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AwsElasticBlockStoreVolume that = (AwsElasticBlockStoreVolume) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(volumeId, that.volumeId)) return false;
    if (!java.util.Objects.equals(partition, that.partition)) return false;
    if (!java.util.Objects.equals(fsType, that.fsType)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  volumeId,  partition,  fsType,  readOnly,  super.hashCode());
  }
  

}