package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AwsElasticBlockStoreVolumeFluent<A extends AwsElasticBlockStoreVolumeFluent<A>> extends BaseFluent<A>{
  public AwsElasticBlockStoreVolumeFluent() {
  }
  
  public AwsElasticBlockStoreVolumeFluent(AwsElasticBlockStoreVolume instance) {
    this.copyInstance(instance);
  }
  private String volumeName;
  private String volumeId;
  private Integer partition;
  private String fsType;
  private Boolean readOnly;
  
  protected void copyInstance(AwsElasticBlockStoreVolume instance) {
    instance = (instance != null ? instance : new AwsElasticBlockStoreVolume());
    if (instance != null) {
          this.withVolumeName(instance.getVolumeName());
          this.withVolumeId(instance.getVolumeId());
          this.withPartition(instance.getPartition());
          this.withFsType(instance.getFsType());
          this.withReadOnly(instance.getReadOnly());
        }
  }
  
  public String getVolumeName() {
    return this.volumeName;
  }
  
  public A withVolumeName(String volumeName) {
    this.volumeName = volumeName;
    return (A) this;
  }
  
  public boolean hasVolumeName() {
    return this.volumeName != null;
  }
  
  public String getVolumeId() {
    return this.volumeId;
  }
  
  public A withVolumeId(String volumeId) {
    this.volumeId = volumeId;
    return (A) this;
  }
  
  public boolean hasVolumeId() {
    return this.volumeId != null;
  }
  
  public Integer getPartition() {
    return this.partition;
  }
  
  public A withPartition(Integer partition) {
    this.partition = partition;
    return (A) this;
  }
  
  public boolean hasPartition() {
    return this.partition != null;
  }
  
  public String getFsType() {
    return this.fsType;
  }
  
  public A withFsType(String fsType) {
    this.fsType = fsType;
    return (A) this;
  }
  
  public boolean hasFsType() {
    return this.fsType != null;
  }
  
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  public A withReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
    return (A) this;
  }
  
  public boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AwsElasticBlockStoreVolumeFluent that = (AwsElasticBlockStoreVolumeFluent) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(volumeId, that.volumeId)) return false;
    if (!java.util.Objects.equals(partition, that.partition)) return false;
    if (!java.util.Objects.equals(fsType, that.fsType)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  volumeId,  partition,  fsType,  readOnly,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName + ","); }
    if (volumeId != null) { sb.append("volumeId:"); sb.append(volumeId + ","); }
    if (partition != null) { sb.append("partition:"); sb.append(partition + ","); }
    if (fsType != null) { sb.append("fsType:"); sb.append(fsType + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReadOnly() {
    return withReadOnly(true);
  }
  

}