package io.dekorate.kubernetes.config;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class AzureDiskVolume{
  public AzureDiskVolume() {
  }
  
  public AzureDiskVolume(String volumeName,String diskName,String diskURI,String kind,String cachingMode,String fsType,Boolean readOnly) {
    this.volumeName = volumeName;
    this.diskName = diskName;
    this.diskURI = diskURI;
    this.kind = kind;
    this.cachingMode = cachingMode;
    this.fsType = fsType;
    this.readOnly = readOnly;
  }
  private String volumeName;
  private String diskName;
  private String diskURI;
  private String kind;
  private String cachingMode;
  private String fsType;
  private Boolean readOnly;
  
  
  /**
   * The volumeName name.
   * @return The volumeName name.
   */
  public String getVolumeName() {
    return this.volumeName;
  }
  
  
  /**
   * The name of the disk to mount.
   * @return The name.
   */
  public String getDiskName() {
    return this.diskName;
  }
  
  public String getDiskURI() {
    return this.diskURI;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public String getCachingMode() {
    return this.cachingMode;
  }
  
  public String getFsType() {
    return this.fsType;
  }
  
  
  /**
   * Wether the volumeName is read only or not.
   * @return True if read only, False otherwise.
   */
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  
  /**
   * Wether the volumeName is read only or not.
   * @return True if read only, False otherwise.
   */
  public boolean isReadOnly() {
    return this.readOnly != null &&  this.readOnly;
  }
  
  public static AzureDiskVolumeBuilder newBuilder() {
    return new AzureDiskVolumeBuilder();
  }
  
  public static AzureDiskVolumeBuilder newBuilderFromDefaults() {
    return new AzureDiskVolumeBuilder().withKind("Managed").withCachingMode("ReadWrite").withFsType("ext4").withReadOnly(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureDiskVolume that = (AzureDiskVolume) o;
    if (!java.util.Objects.equals(volumeName, that.volumeName)) return false;
    if (!java.util.Objects.equals(diskName, that.diskName)) return false;
    if (!java.util.Objects.equals(diskURI, that.diskURI)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(cachingMode, that.cachingMode)) return false;
    if (!java.util.Objects.equals(fsType, that.fsType)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(volumeName,  diskName,  diskURI,  kind,  cachingMode,  fsType,  readOnly,  super.hashCode());
  }
  

}